/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;

public class InitialScreenshotHelper {
    private static Uri screenshotUri;

    public static void captureScreenshot(@NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        InitialScreenshotCapturingListener initialScreenshotCapturingListener;
        final Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity == null) {
            return;
        }
        if (MemoryUtils.isLowMemory((Context)activity)) {
            Activity activity2 = activity;
            InstabugSDKLogger.e(InitialScreenshotHelper.class, "Couldn't take initial screenshot due to low memory");
            initialScreenshotCapturingListener.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
            Toast.makeText((Context)activity2, (CharSequence)LocaleUtils.getLocaleStringResource(Instabug.getLocale((Context)activity2), R.string.instabug_str_capturing_screenshot_error, (Context)activity), (int)0).show();
            return;
        }
        if (InitialScreenshotHelper.isUsingMediaProjection()) {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener2 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    a a2 = a3;
                    a a3 = a2.activity;
                    InitialScreenshotHelper.access$000(bitmap, (Activity)a3, a2.initialScreenshotCapturingListener);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    a a2 = this;
                    InstabugSDKLogger.e(a2, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                    a2.initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            };
            ScreenshotProvider.a(true, activity, screenshotCapturingListener2);
        } else {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener3 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    b b2 = b3;
                    b b3 = b2.activity;
                    InitialScreenshotHelper.access$000(bitmap, (Activity)b3, b2.initialScreenshotCapturingListener);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    b b2 = this;
                    InstabugSDKLogger.e(b2, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                    b2.initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            };
            ScreenshotProvider.a(activity, screenshotCapturingListener3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void saveBitmap(Bitmap bitmap, Activity activity, InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        void var1_1;
        void var2_2;
        BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
        Object object = onSaveBitmapCallback;
        onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback((InitialScreenshotCapturingListener)var2_2){
            final /* synthetic */ InitialScreenshotCapturingListener a;
            {
                this.a = initialScreenshotCapturingListener;
            }

            @Override
            public void onSuccess(Uri uri) {
                screenshotUri = uri;
                this.a.onScreenshotCapturedSuccessfully(uri);
            }

            @Override
            public void onError(Throwable throwable) {
                c c2 = this;
                InstabugSDKLogger.e(c2, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                c2.a.onScreenshotCapturingFailed(throwable);
            }
        };
        BitmapUtils.saveBitmap(bitmap, (Context)var1_1, (BitmapUtils.OnSaveBitmapCallback)object);
    }

    private static boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Bitmap x0, Activity x1, InitialScreenshotCapturingListener x2) {
        void var2_2;
        void var1_1;
        InitialScreenshotHelper.saveBitmap(x0, (Activity)var1_1, (InitialScreenshotCapturingListener)var2_2);
    }

    public static interface InitialScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Uri var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

