/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.model;

import androidx.annotation.DrawableRes;
import com.instabug.bug.settings.a;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportCategory {
    private static final String TAG = "ReportCategory";
    private static final String KEY_LABEL = "name";
    private static final String KEY_SUBS = "subs";
    private static final String KEY_SLUG = "slug";
    private static final String CATEGORY_REPORT_A_PROBLEM = "report-a-problem";
    private static final String CATEGORY_SUGGEST_AN_IMPROVEMENT = "suggest-an-improvement";
    private static final String CATEGORY_ASK_A_QUESTION = "ask-a-question";
    private static final String KEY_DESCRIPTION = "description";
    private String description;
    private String label;
    private int icon;
    private List<ReportCategory> subs;

    private ReportCategory() {
    }

    public static ReportCategory getInstance() {
        return new ReportCategory();
    }

    private static ReportCategory fromJsonObject(JSONObject jsonObject) throws JSONException {
        ArrayList<ReportCategory> arrayList;
        JSONObject jSONObject;
        ReportCategory reportCategory;
        ReportCategory reportCategory2 = reportCategory;
        reportCategory = new ReportCategory();
        if (jsonObject.has(KEY_LABEL)) {
            reportCategory2.setLabel(jSONObject.getString(KEY_LABEL));
        }
        if (jSONObject.has(KEY_DESCRIPTION)) {
            reportCategory2.setDescription(jSONObject.getString(KEY_DESCRIPTION));
        }
        ArrayList<ReportCategory> arrayList2 = arrayList;
        arrayList = new ArrayList<ReportCategory>();
        if (jSONObject.has(KEY_SUBS)) {
            jSONObject = jSONObject.getJSONArray(KEY_SUBS);
            for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
                arrayList2.add(ReportCategory.fromJsonObject(jSONObject.getJSONObject(i2)));
            }
        }
        ReportCategory reportCategory3 = reportCategory2;
        reportCategory3.setSubs(arrayList2);
        return reportCategory3;
    }

    /*
     * WARNING - void declaration
     */
    private void setSubs(List<ReportCategory> subs) {
        void var1_1;
        this.subs = var1_1;
    }

    public static List<ReportCategory> getSubReportCategories(String reportType) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories(reportType);
        if (list == null) {
            list = a.r().i();
        }
        return list;
    }

    private static List<ReportCategory> getRemoteSubReportCategories(String reportType) {
        block16: {
            String string2 = a.r().h();
            if (string2 != null) {
                JSONArray jSONArray;
                List<ReportCategory> list;
                block17: {
                    block15: {
                        JSONArray jSONArray2;
                        String string3 = list;
                        jSONArray = jSONArray2;
                        jSONArray2 = new JSONArray(string2);
                        if (!string3.equals("bug")) break block15;
                        list = ReportCategory.getSubCategories(jSONArray, CATEGORY_REPORT_A_PROBLEM);
                        if (list == null) break block16;
                        if (list.size() > 0) {
                            return list;
                        }
                    }
                    if (!((String)((Object)list)).equals("feedback")) break block17;
                    list = ReportCategory.getSubCategories(jSONArray, CATEGORY_SUGGEST_AN_IMPROVEMENT);
                    if (list == null) break block16;
                    if (list.size() > 0) {
                        return list;
                    }
                }
                if (!((String)((Object)list)).equals("ask a question")) break block16;
                list = ReportCategory.getSubCategories(jSONArray, CATEGORY_ASK_A_QUESTION);
                if (list == null) break block16;
                try {
                    if (list.size() > 0) {
                        return list;
                    }
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((Object)TAG, (String)"error while getRemoteSubReportCategories", (Throwable)jSONException);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static List<ReportCategory> getSubCategories(JSONArray jsonArray, String slug) throws JSONException {
        JSONArray jSONArray;
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            void var1_1;
            if (!var1_1.equals(jSONArray.getJSONObject(i2).getString(KEY_SLUG))) continue;
            return ReportCategory.fromJsonObject(jSONArray.getJSONObject(i2)).getSubs();
        }
        return null;
    }

    public static boolean hasSubCategories(String reportType) {
        List<ReportCategory> list;
        List<ReportCategory> list2 = ReportCategory.getRemoteSubReportCategories("bug");
        List<ReportCategory> list3 = ReportCategory.getRemoteSubReportCategories("feedback");
        List<ReportCategory> list4 = ReportCategory.getRemoteSubReportCategories("ask a question");
        boolean bl = false;
        if (list2 != null && !list2.isEmpty()) {
            if (((String)((Object)list)).equals("bug")) {
                return true;
            }
            bl = true;
        }
        if (list3 != null && !list3.isEmpty()) {
            if (((String)((Object)list)).equals("feedback")) {
                return true;
            }
            bl = true;
        }
        if (list4 != null && !list4.isEmpty()) {
            if (((String)((Object)list)).equals("ask a question")) {
                return true;
            }
            bl = true;
        }
        list = a.r().i();
        return !bl && list != null && list.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public ReportCategory withLabel(String label) {
        void var1_1;
        this.label = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ReportCategory withIcon(@DrawableRes int icon) {
        void var1_1;
        this.icon = var1_1;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - void declaration
     */
    public void setLabel(String label) {
        void var1_1;
        this.label = StringUtility.ellipsize((String)var1_1, (int)35);
    }

    public int getIcon() {
        return this.icon;
    }

    /*
     * WARNING - void declaration
     */
    public void setIcon(@DrawableRes int icon) {
        void var1_1;
        this.icon = var1_1;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ReportCategory> getSubs() {
        return this.subs;
    }

    /*
     * WARNING - void declaration
     */
    public void setDescription(String description) {
        void var1_1;
        this.description = StringUtility.ellipsize((String)var1_1, (int)75);
    }
}

