/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.instabug.bug.h.a;
import com.instabug.chat.ChatsDelegate;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BugReporting {
    private static final String TAG = "BugReporting";

    public static void setInvocationEvents(InstabugInvocationEvent ... invocationEvents) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)TextUtils.join((CharSequence)",", (Object[])invocationEvents))});
        InvocationManager.getInstance().setInstabugInvocationEvent(invocationEvents);
    }

    public static void setOptions(int ... options) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("options").setType(int[].class)});
        com.instabug.bug.a.a(options);
    }

    public static void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setOnInvokeCallback").setType(Runnable.class)});
        InstabugSDKLogger.i((Object)TAG, (String)"setInvokeCallback");
        SettingsManager.getInstance().setOnInvokeCallback(onInvokeCallback);
    }

    public static void setOnDismissCallback(OnSdkDismissCallback onSdkDismissedCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class)});
        InstabugSDKLogger.i((Object)TAG, (String)"setOnDismissCallback");
        ChatsDelegate.setOnSdkDismissCallback((OnSdkDismissCallback)onSdkDismissedCallback);
        com.instabug.bug.settings.a.r().a(onSdkDismissedCallback);
    }

    public static void setShakingThreshold(int threshold) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue((Object)Integer.toString(threshold))});
        InstabugSDKLogger.i((Object)TAG, (String)("setShakingThreshold: " + threshold));
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(threshold);
    }

    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge)});
        InstabugSDKLogger.i((Object)TAG, (String)("setFloatingButtonEdge: " + instabugFloatingButtonEdge));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
    }

    public static void setFloatingButtonOffset(@IntRange(from=0L) int floatingButtonOffsetFromTop) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue((Object)Integer.toString(floatingButtonOffsetFromTop))});
        InstabugSDKLogger.i((Object)TAG, (String)("setFloatingButtonOffset: " + floatingButtonOffsetFromTop));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
    }

    public static void setVideoRecordingFloatingButtonPosition(@NonNull InstabugVideoRecordingButtonPosition instabugViewRecordingButtonPosition) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugViewRecordingButtonPosition").setType(InstabugVideoRecordingButtonPosition.class).setValue((Object)instabugViewRecordingButtonPosition)});
        InstabugSDKLogger.i((Object)TAG, (String)("setVideoRecordingFloatingButtonPosition: " + instabugViewRecordingButtonPosition));
        InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(instabugViewRecordingButtonPosition);
    }

    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i((Object)TAG, (String)("setExtendedBugReportState: " + state));
        int n2 = a.a[state.ordinal()];
        a.a a2 = n2 != 1 ? (n2 != 2 ? a.a.DISABLED : a.a.ENABLED_WITH_OPTIONAL_FIELDS) : a.a.ENABLED_WITH_REQUIRED_FIELDS;
        com.instabug.bug.settings.a.r().a(a2);
    }

    @RequiresApi(value=21)
    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setAutoScreenRecordingEnabled").setType(Boolean.class).setValue((Object)String.valueOf(autoScreenRecordingEnabled))});
        InstabugSDKLogger.i((Object)TAG, (String)("setAutoScreenRecordingEnabled: " + autoScreenRecordingEnabled));
        com.instabug.bug.a.a(autoScreenRecordingEnabled);
    }

    public static void setReportTypes(int ... types) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("types").setType(int[].class)});
        com.instabug.bug.a.b(types);
    }

    public static void show(@ReportType int type) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("type").setType(Integer.TYPE)});
        com.instabug.bug.a.a(type);
    }

    public static void show(@ReportType int type, int ... options) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("type").setType(Integer.TYPE)});
        com.instabug.bug.a.a(type, options);
    }

    public static void setState(Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("state").setType(Feature.State.class)});
        com.instabug.bug.a.b(state);
    }

    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state)});
        InstabugSDKLogger.i((Object)TAG, (String)("setViewHierarchyState: " + state));
        InstabugCore.setFeatureState((Feature)Feature.VIEW_HIERARCHY_V2, (Feature.State)state);
    }

    public static void setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean imageFromGallery, boolean screenRecording) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("initialScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(initialScreenshot)), new Api.Parameter().setName("extraScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(extraScreenshot)), new Api.Parameter().setName("galleryImage").setType(Boolean.class).setValue((Object)Boolean.toString(imageFromGallery)), new Api.Parameter().setName("screenRecording").setType(Boolean.class).setValue((Object)Boolean.toString(screenRecording))});
        InstabugCore.setInitialScreenShotAllowed((boolean)initialScreenshot);
        com.instabug.bug.a.a(initialScreenshot, extraScreenshot, imageFromGallery, screenRecording);
    }

    @RequiresApi(value=21)
    public static void setScreenshotByMediaProjectionEnabled(boolean enabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i((Object)TAG, (String)("setScreenshotByMediaProjectionEnabled: " + enabled));
        SettingsManager.getInstance().setScreenshotByMediaProjectionEnabled(enabled);
    }

    protected static void setScreenshotRequired(boolean screenshotRequired) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("screenshotRequired").setType(Boolean.TYPE)});
        InstabugSDKLogger.i((Object)TAG, (String)("setScreenshotRequired: " + screenshotRequired));
        com.instabug.bug.settings.a.r().e(screenshotRequired);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReportType {
        public static final int BUG = 0;
        public static final int FEEDBACK = 1;
        public static final int QUESTION = 2;
    }
}

