/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.model;

import android.support.annotation.DrawableRes;
import com.instabug.bug.settings.a;
import com.instabug.library.util.StringUtility;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportCategory {
    private static final String KEY_LABEL = "name";
    private static final String KEY_SUBS = "subs";
    private static final String KEY_SLUG = "slug";
    private static final String CATEGORY_REPORT_A_PROBLEM = "report-a-problem";
    private static final String CATEGORY_SUGGEST_AN_IMPROVEMENT = "suggest-an-improvement";
    private static final String CATEGORY_ASK_A_QUESTION = "ask-a-question";
    private static final String KEY_DESCRIPTION = "description";
    private String description;
    private String label;
    private int icon;
    private List<ReportCategory> subs;

    private ReportCategory() {
    }

    public static ReportCategory getInstance() {
        return new ReportCategory();
    }

    public ReportCategory withLabel(String label) {
        this.label = label;
        return this;
    }

    public ReportCategory withIcon(@DrawableRes int icon) {
        this.icon = icon;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = StringUtility.ellipsize((String)label, (int)35);
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(@DrawableRes int icon) {
        this.icon = icon;
    }

    private static ReportCategory fromJsonObject(JSONObject jsonObject) throws JSONException {
        ReportCategory reportCategory = new ReportCategory();
        if (jsonObject.has(KEY_LABEL)) {
            reportCategory.setLabel(jsonObject.getString(KEY_LABEL));
        }
        if (jsonObject.has(KEY_DESCRIPTION)) {
            reportCategory.setDescription(jsonObject.getString(KEY_DESCRIPTION));
        }
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        if (jsonObject.has(KEY_SUBS)) {
            JSONArray jSONArray = jsonObject.getJSONArray(KEY_SUBS);
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(ReportCategory.fromJsonObject(jSONArray.getJSONObject(i)));
            }
        }
        reportCategory.setSubs(arrayList);
        return reportCategory;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ReportCategory> getSubs() {
        return this.subs;
    }

    private void setSubs(List<ReportCategory> subs) {
        this.subs = subs;
    }

    public void setDescription(String description) {
        this.description = StringUtility.ellipsize((String)description, (int)75);
    }

    public static List<ReportCategory> getSubReportCategories(String reportType) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories(reportType);
        return list != null ? list : a.a().b();
    }

    private static List<ReportCategory> getRemoteSubReportCategories(String reportType) {
        String string2 = a.a().c();
        if (string2 != null) {
            try {
                List<ReportCategory> list;
                JSONArray jSONArray = new JSONArray(string2);
                if (reportType.equals("bug")) {
                    List<ReportCategory> list2 = ReportCategory.getSubCategories(jSONArray, CATEGORY_REPORT_A_PROBLEM);
                    if (list2 != null && list2.size() > 0) {
                        return list2;
                    }
                } else if (reportType.equals("feedback")) {
                    List<ReportCategory> list3 = ReportCategory.getSubCategories(jSONArray, CATEGORY_SUGGEST_AN_IMPROVEMENT);
                    if (list3 != null && list3.size() > 0) {
                        return list3;
                    }
                } else if (reportType.equals("ask a question") && (list = ReportCategory.getSubCategories(jSONArray, CATEGORY_ASK_A_QUESTION)) != null && list.size() > 0) {
                    return list;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return null;
    }

    private static List<ReportCategory> getSubCategories(JSONArray jsonArray, String slug) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            String string2 = jsonArray.getJSONObject(i).getString(KEY_SLUG);
            if (!slug.equals(string2)) continue;
            return ReportCategory.fromJsonObject(jsonArray.getJSONObject(i)).getSubs();
        }
        return null;
    }

    public static boolean hasSubCategories(String reportType) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories("bug");
        List<ReportCategory> list2 = ReportCategory.getRemoteSubReportCategories("feedback");
        List<ReportCategory> list3 = ReportCategory.getRemoteSubReportCategories("ask a question");
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            if (reportType.equals("bug")) {
                return true;
            }
            bl = true;
        }
        if (list2 != null && !list2.isEmpty()) {
            if (reportType.equals("feedback")) {
                return true;
            }
            bl = true;
        }
        if (list3 != null && !list3.isEmpty()) {
            if (reportType.equals("ask a question")) {
                return true;
            }
            bl = true;
        }
        List<ReportCategory> list4 = a.a().b();
        return !bl && list4 != null && list4.size() > 0;
    }
}

