/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.model;

import android.support.annotation.DrawableRes;
import com.instabug.bug.model.b;
import com.instabug.bug.settings.a;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportCategory {
    private static final String KEY_LABEL = "name";
    private static final String KEY_SUBS = "subs";
    private static final String KEY_SLUG = "slug";
    private static final String CATEGORY_REPORT_A_PROBLEM = "report-a-problem";
    private static final String CATEGORY_SUGGEST_AN_IMPROVEMENT = "suggest-an-improvement";
    private String label;
    private int icon;
    private List<ReportCategory> subs;

    private ReportCategory() {
    }

    public static ReportCategory getInstance() {
        return new ReportCategory();
    }

    public ReportCategory withLabel(String string2) {
        this.label = string2;
        return this;
    }

    public ReportCategory withIcon(@DrawableRes int n) {
        this.icon = n;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string2) {
        this.label = string2;
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(@DrawableRes int n) {
        this.icon = n;
    }

    public List<ReportCategory> getSubs() {
        return this.subs;
    }

    private void setSubs(List<ReportCategory> list) {
        this.subs = list;
    }

    private static ReportCategory fromJsonObject(JSONObject jSONObject) throws JSONException {
        ReportCategory reportCategory = new ReportCategory();
        if (jSONObject.has(KEY_LABEL)) {
            reportCategory.setLabel(jSONObject.getString(KEY_LABEL));
        }
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        if (jSONObject.has(KEY_SUBS)) {
            JSONArray jSONArray = jSONObject.getJSONArray(KEY_SUBS);
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(ReportCategory.fromJsonObject(jSONArray.getJSONObject(i)));
            }
        }
        reportCategory.setSubs(arrayList);
        return reportCategory;
    }

    public static List<ReportCategory> getSubReportCategories(b b2) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories(b2);
        return list != null ? list : a.a().b();
    }

    private static List<ReportCategory> getRemoteSubReportCategories(b b2) {
        String string2 = a.a().c();
        if (string2 != null) {
            try {
                List<ReportCategory> list;
                JSONArray jSONArray = new JSONArray(string2);
                if (b2 == b.BUG) {
                    List<ReportCategory> list2 = ReportCategory.getSubCategories(jSONArray, CATEGORY_REPORT_A_PROBLEM);
                    if (list2 != null && list2.size() > 0) {
                        return list2;
                    }
                } else if (b2 == b.FEEDBACK && (list = ReportCategory.getSubCategories(jSONArray, CATEGORY_SUGGEST_AN_IMPROVEMENT)) != null && list.size() > 0) {
                    return list;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return null;
    }

    private static List<ReportCategory> getSubCategories(JSONArray jSONArray, String string2) throws JSONException {
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string3 = jSONArray.getJSONObject(i).getString(KEY_SLUG);
            if (!string2.equals(string3)) continue;
            return ReportCategory.fromJsonObject(jSONArray.getJSONObject(i)).getSubs();
        }
        return null;
    }

    public static boolean hasSubCategories(b b2) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories(b.BUG);
        List<ReportCategory> list2 = ReportCategory.getRemoteSubReportCategories(b.FEEDBACK);
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            if (b2 == b.BUG) {
                return true;
            }
            bl = true;
        }
        if (list2 != null && !list2.isEmpty()) {
            if (b2 == b.FEEDBACK) {
                return true;
            }
            bl = true;
        }
        List<ReportCategory> list3 = a.a().b();
        return !bl && list3 != null && list3.size() > 0;
    }
}

