package com.instabug.bug.reportingpromptitems;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_QUESTION;
import static com.instabug.library.util.LocaleUtils.getLocaleStringResource;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.bug.Constants;
import com.instabug.bug.Constants.MainReportCategory;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.ReportingActivityLauncher;
import com.instabug.bug.model.ReportCategory;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InvocationMode;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivity;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;

import java.util.ArrayList;

public class AskQuestionPromptItem extends BaseReportingPromptItem {

    @Override
    public PluginPromptOption getItemOption(final Context context) {
        PluginPromptOption promptOption = new PluginPromptOption();
        promptOption.setOrder(Constants.PromptItemOrder.ORDER_ASK_A_QUESTION_OPTION);
        promptOption.setInvocationMode(InvocationMode.ASK_QUESTION);
        promptOption.setInitialScreenshotRequired(true);
        promptOption.setIcon(com.instabug.bug.R.drawable.ibg_core_ic_question);
        promptOption.setPromptOptionIdentifier(PluginPromptOption.PromptOptionIdentifier.ASK_QUESTION);
        promptOption.setTitle(getReportTitle(context));
        promptOption.setDescription(getReportDescription(context));
        promptOption.setOnInvocationListener(new PluginPromptOption.OnInvocationListener() {
            @Override
            public void onInvoke(@Nullable Uri initialScreenshotUri, String... reportCategories) {
                invoke(context, initialScreenshotUri, reportCategories);
            }
        });
        promptOption.setSubOptions(getSubOptions(Constants.ReportType.ASK_QUESTION));
        return promptOption;


    }


    /**
     * A method to invoke ask question, first it do the below:
     * - trigger sdk callback if any
     * - create a report with provided screenshot if any
     * - add {@link MainReportCategory#ASK_QUESTION} as main category
     * - launch subcategories intent if found
     * - if now subcategories found it terminate the prompt option then start ask question intent.
     * @param context
     * @param initialScreenshotUri
     * @param reportCategories
     */
    protected void invoke(Context context, @Nullable Uri initialScreenshotUri, String... reportCategories) {
        callOnSdkInvoked();
        InstabugSDKLogger.v(Constants.LOG_TAG, "Handle invocation ask a " +
                "question ");
        createReportWithInitialScreenshot(initialScreenshotUri);
        if (LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().setCategories(new ArrayList<String>());
            LiveBugManager.getInstance().getBug()
                    .addCategory(MainReportCategory.ASK_QUESTION);
            for (String reportCategory : reportCategories) {
                LiveBugManager.getInstance().getBug()
                        .addCategory(reportCategory);
            }
        }
        startViewHierarchyInspection();
        // to close the dialog if opened
        Intent intent = InstabugDialogActivity.getIntent(context, null, null, null, true);
        context.startActivity(intent);
        handleNewReport(context);
    }

    @Override
    @VisibleForTesting
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    String getReportTitle(Context context) {
        String defaultTitle = getLocaleStringResource(InstabugCore.getLocale(context), com.instabug.library.R
                .string.askAQuestionHeader, context);
        return PlaceHolderUtils.getPlaceHolder(REPORT_QUESTION, defaultTitle);
    }

    @Override
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    String getReportDescription(Context context) {
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REPORT_QUESTION_DESCRIPTION,
                getLocaleStringResource(InstabugCore.getLocale(context),
                        com.instabug.library.R.string.ib_bug_report_question_description, context));
    }

    @Override
    void handleNewReport(Context context) {
        context.startActivity(ReportingActivityLauncher.newAskAQuestionIntent(context));
    }

    @Override
    protected PluginPromptOption getSubOption(ReportCategory reportCategory,
                                              @Nullable PluginPromptOption parent,
                                              @Constants.ReportType String reportType, int order) {
        PluginPromptOption subOption = super.getSubOption(reportCategory, parent, reportType, order);
        subOption.setInvocationMode(InvocationMode.ASK_QUESTION);
        subOption.setPromptOptionIdentifier(PluginPromptOption.PromptOptionIdentifier.ASK_QUESTION);
        return subOption;
    }
}
