package com.instabug.chat.ui;


import static com.instabug.chat.ui.ChatActivityLauncher.ChatProcess;
import static com.instabug.chat.ui.ChatActivityLauncher.PROCESS_CHAT;
import static com.instabug.chat.ui.ChatActivityLauncher.PROCESS_CHATS;
import static com.instabug.chat.ui.ChatActivityLauncher.PROCESS_HANGING_CHAT;

import androidx.annotation.Nullable;

import com.instabug.chat.ChatsDelegate;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.core.ui.BasePresenter;

public class ChatPresenter extends BasePresenter<ChatContract.View> implements ChatContract
        .Presenter {

    @ChatProcess
    private int currentProcess;
    public ChatPresenter(ChatContract.View view) {
        super(view);
    }

    @Override
    public void handleChatProcess(@ChatProcess int currentProcess) {
        if (currentProcess == PROCESS_CHATS) {
            handleChatsProcess();
        } else if (currentProcess == PROCESS_CHAT) {
            if (view != null) {
                ChatContract.View v = view.get();
                if (v != null && v.getChatProcessChatNumber() != null) {
                    handleChatProcess(v.getChatProcessChatNumber());
                }
            }
        }else if (currentProcess == PROCESS_HANGING_CHAT) {
            if (view != null) {
                ChatContract.View v = view.get();
                if (v != null && v.getChatProcessChatNumber() != null && v.getChatProcessChatAttachment() != null) {
                    handleHangingChat(v.getChatProcessChatNumber(),
                            v.getChatProcessChatAttachment());
                }
            }
        }
        this.currentProcess = currentProcess;
    }

    public @ChatProcess int getCurrentProcess() {
        return currentProcess;
    }

    public void setCurrentProcess(@ChatProcess int currentProcess) {
        this.currentProcess = currentProcess;
    }
    @Override
    public void handleOpenChatRequest(String chatNumber) {
        handleChatProcess(chatNumber);
    }



    @Override
    public void handleOnSdkDismissed() {
        OnSdkDismissCallback onSdkDismissCallback = ChatSettings.getOnSdkDismissCallback();
        if (onSdkDismissCallback != null) {
            onSdkDismissCallback.call(OnSdkDismissCallback.DismissType.CANCEL,
                    OnSdkDismissCallback.ReportType.OTHER);
        }
        view = null;
    }

    @Override
    public void dismissSystemNotification() {
        ChatsDelegate.dismissSystemNotification();
    }

    private void handleChatsProcess() {
        if (isUserHasChats()) {
            if (view != null) {
                ChatContract.View v = view.get();
                if (v != null) {
                    v.showChatsFragment();
                }
            }
        }
    }

    private void handleChatProcess(String chatNumber) {
        ChatContract.View v = null;
        if (view != null) {
            v = view.get();
        }

        if (isUserHasChats()) {
            if (v != null) {
                v.showChatsFragment();
            }
        }
        if (v != null) {
            v.showChatFragment(chatNumber);
        }
    }

    private void handleHangingChat(String chatNumber, Attachment attachment) {
        ChatContract.View v = null;
        if (view != null) {
            v = view.get();
        }

        if (isUserHasChats()) {
            if (v != null) {
                v.showChatsFragment();
            }

        }
        if (v != null) {
            v.showChatFragment(chatNumber, attachment);
        }
    }

    private boolean isUserHasChats() {
        return ChatsCacheManager.getValidChats().size() > 0;
    }

    @Nullable
    private Chat createOfflineChat() {
        if (view != null) {
            ChatContract.View viewRef = view.get();
            if (viewRef != null) {
                return ChatsCacheManager.addOfflineChat(viewRef.getViewContext());
            }
        }
        return null;
    }

}
