package com.instabug.bug.ui.promptoptions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.annotation.Nullable;

import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogAction;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivity;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.threading.PoolProvider;

import java.util.ArrayList;

/**
 * Created by mzelzoghbi on 4/18/18.
 */
public class PromptOptionsLauncher {
    private static PromptOptionsLauncher INSTANCE;

    public static synchronized PromptOptionsLauncher getInstance() {
        return INSTANCE == null ? (INSTANCE = new PromptOptionsLauncher()) : INSTANCE;
    }

    public void launchPromptOptionsActivity(Activity currentActivity, @Nullable Uri screenshot) {
        String title = getPromptOptionTitle(currentActivity);
        Intent intent = InstabugDialogActivity.getIntent(currentActivity,
                title, screenshot, getItems(), false);
        PoolProvider.postMainThreadTask(() ->
                currentActivity.startActivity(intent)
        );
    }


    public void launchPromptOptionsActivity(final Activity currentActivity, @Nullable final Uri screenshot,
                                            @Nullable final String title, @Nullable final ArrayList<InstabugDialogItem> items) {
        PoolProvider.postMainThreadTask(new Runnable() {
            @Override
            public void run() {
                Intent intent = InstabugDialogActivity.getIntent(currentActivity, title, screenshot, items,
                        false);
                currentActivity.startActivity(intent);
            }
        });
    }

    @Nullable
    private String getPromptOptionTitle(Context context) {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.INVOCATION_HEADER,
                LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context),
                        R.string.instabug_str_invocation_dialog_title, context));
    }

    private ArrayList<InstabugDialogItem> getItems() {
        ArrayList<PluginPromptOption> options = InvocationManager.getInstance().getAvailablePromptOptions();
        return getItems(options);
    }

    private ArrayList<InstabugDialogItem> getItems(ArrayList<PluginPromptOption> options) {
        ArrayList<InstabugDialogItem> items = new ArrayList<>();
        for (int i = 0; i < (options != null ? options.size() : 0); i++) {
            items.add(getItem(options.get(i), null));
        }
        return items;
    }

    public InstabugDialogItem getItem(PluginPromptOption option, @Nullable InstabugDialogItem parent) {
        InstabugDialogItem dialogItem;
        if (option.getOrder() == PluginPromptOption.NO_ORDER) {
            dialogItem = new InstabugDialogAction();
            dialogItem.setOrder(-1);
        } else {
            dialogItem = new InstabugDialogItem();
            dialogItem.setOrder(option.getOrder());
        }
        dialogItem.setResDrawable(option.getIcon());
        dialogItem.setTitle(option.getTitle());
        dialogItem.setDescription(option.getDescription());
        dialogItem.setBadge(option.getNotificationCount());
        dialogItem.setInitialScreenshotRequired(option.isInitialScreenshotRequired());
        dialogItem.setParent(parent);
        dialogItem.setSubItems(getSubItems(option.getSubOptions(), dialogItem));
        dialogItem.setIdentifier(option.getPromptOptionIdentifier());
        return dialogItem;
    }

    @SuppressLint("ERADICATE_NULLABLE_DEREFERENCE")
    private ArrayList<InstabugDialogItem> getSubItems(@Nullable ArrayList<PluginPromptOption> options,
                                                      @Nullable InstabugDialogItem parent) {
        ArrayList<InstabugDialogItem> items = new ArrayList<>();
        for (int i = 0; i < (options != null ? options.size() : 0); i++) {
            if (options.get(i) != null) {
                items.add(getItem(options.get(i), parent));
            }
        }
        return items;
    }
}
