package com.instabug.bug.view.annotation;

import android.graphics.Bitmap;

import androidx.annotation.Nullable;

import com.instabug.library.core.ui.BasePresenter;

class AnnotationPresenter extends BasePresenter<AnnotationContract.View> implements
        AnnotationContract.Presenter {


    AnnotationPresenter(AnnotationContract.View view) {
        super(view);
    }

    void loadViewData(@Nullable Bitmap bitmap) {
        if (view != null) {
            AnnotationContract.View viewRef = view.get();
            if (viewRef != null) {

                if (bitmap != null) {
                    viewRef.setAnnotationBitmap(bitmap);
                } else {
                    viewRef.showToastError();
                }
            }
        }
    }
}
