/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chats;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.synchronization.NewMessagesHandler;
import com.instabug.chat.synchronization.OnNewMessagesReceivedListener;
import com.instabug.chat.ui.chats.ChatsContract$Presenter;
import com.instabug.chat.ui.chats.ChatsContract$View;
import com.instabug.library.Instabug;
import com.instabug.library.PresentationManager;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivexport.Observer;
import io.reactivexport.android.schedulers.AndroidSchedulers;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.observers.DisposableObserver;
import io.reactivexport.subjects.PublishSubject;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

class ChatsPresenter
extends BasePresenter<ChatsContract$View>
implements ChatsContract$Presenter,
CacheChangedListener<Chat>,
OnNewMessagesReceivedListener {
    @Nullable
    private PublishSubject<Long> chatsCacheUpdatePublishSubject;
    @Nullable
    private Disposable chatsCacheUpdateDisposable;

    ChatsPresenter(ChatsContract$View chatsContract$View) {
        super((BaseContract.View)chatsContract$View);
    }

    private void updateChatsFromCache(long l) {
        PublishSubject<Long> publishSubject = publishSubject.chatsCacheUpdatePublishSubject;
        if (publishSubject != null) {
            publishSubject.onNext((Object)l);
        }
    }

    private void subscribeToChatsCacheUpdates() {
        this.chatsCacheUpdatePublishSubject = PublishSubject.create();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        this.chatsCacheUpdateDisposable = (Disposable)this.chatsCacheUpdatePublishSubject.debounce(300L, timeUnit).observeOn(AndroidSchedulers.mainThread()).subscribeWith((Observer)new DisposableObserver<Long>(){

            public void onComplete() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(Long l) {
                ChatsPresenter.this.updateUI();
            }
        });
    }

    private void unSubscribeFromCacheUpdates() {
        Disposable disposable = this.chatsCacheUpdateDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.chatsCacheUpdateDisposable.dispose();
        }
    }

    private void updateUI() {
        ChatsPresenter chatsPresenter = arrayList;
        ArrayList<Chat> arrayList = chatsPresenter.getChatsFromCache();
        Collections.sort(arrayList, Collections.reverseOrder(new Chat.Comparator()));
        Object object = chatsPresenter.view;
        if (object != null && (object = (ChatsContract$View)((Reference)object).get()) != null) {
            Object object2 = object;
            object2.updateChats(arrayList);
            object2.showChats();
        }
    }

    private synchronized ArrayList<Chat> getChatsFromCache() {
        Object object;
        if (ChatsCacheManager.getCache() != null) {
            ArrayList<Chat> arrayList;
            object = arrayList;
            arrayList = new ArrayList<Chat>(ChatsCacheManager.getValidChats());
        } else {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        }
        Object object2 = object;
        Collections.sort(object2, Collections.reverseOrder(new Chat.Comparator()));
        return object2;
    }

    private void subscribeToChatsCache(CacheChangedListener<Chat> cacheChangedListener) {
        try {
            CacheManager.getInstance().subscribe("chats_memory_cache", cacheChangedListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.e((String)"ChatsPresenter", (String)"Couldn't subscribe to cache", (Throwable)illegalArgumentException);
            IBGDiagnostics.reportNonFatal((Throwable)illegalArgumentException, (String)"Couldn't subscribe to cache");
        }
    }

    @Override
    public void start() {
        ChatsPresenter chatsPresenter = this;
        chatsPresenter.subscribeToChatsCacheUpdates();
        chatsPresenter.subscribeToChatsCache(chatsPresenter);
        NewMessagesHandler.getInstance().addOnNewMessagesReceivedListener(this);
        chatsPresenter.updateUI();
    }

    @Override
    public void stop() {
        CacheManager.getInstance().unSubscribe("chats_memory_cache", (CacheChangedListener)this);
        NewMessagesHandler.getInstance().removeOnNewMessagesReceivedListener(this);
        this.unSubscribeFromCacheUpdates();
    }

    @Override
    @Nullable
    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION"})
    public List<Message> onNewMessagesReceived(final @NonNull List<Message> list) {
        Object object = this.view;
        if (object != null && (object = (ChatsContract$View)((Reference)object).get()) != null && ((Fragment)object.getViewContext()).getActivity() != null) {
            if (object.isChatsFragmentVisible()) {
                NotificationManager.getInstance().playNotificationSound((Context)((Fragment)object.getViewContext()).getActivity());
            } else if (Instabug.getApplicationContext() != null) {
                PresentationManager.getInstance().show(new Runnable(){

                    @Override
                    public void run() {
                        if (Instabug.getApplicationContext() != null) {
                            1 v0 = this_;
                            1 this_ = Instabug.getApplicationContext();
                            NotificationManager.getInstance().showNotification((Context)this_, v0.list);
                        }
                    }
                });
            }
        }
        return null;
    }

    public void onCachedItemRemoved(Chat chat) {
        this.updateChatsFromCache(System.currentTimeMillis());
    }

    public void onCachedItemAdded(Chat chat) {
        this.updateChatsFromCache(System.currentTimeMillis());
    }

    public void onCachedItemUpdated(Chat chat, Chat chat2) {
        this.updateChatsFromCache(System.currentTimeMillis());
    }

    public void onCacheInvalidated() {
        this.updateChatsFromCache(System.currentTimeMillis());
    }
}

