/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.bug.R;
import com.instabug.chat.annotation.AnnotationView;
import com.instabug.chat.annotation.ColorPickerPopUpView;
import com.instabug.chat.annotation.ShapeSuggestionsLayout;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.view.IconView;
import com.instabug.library.view.ViewUtils;
import java.io.Serializable;

public class AnnotationLayout
extends LinearLayout
implements View.OnClickListener {
    @Nullable
    private AnnotationView mAnnotationView;
    @Nullable
    private ColorPickerPopUpView colorPicker;
    private int tintingColor;
    @Nullable
    private LinearLayout annotationActionsContainer;
    @Nullable
    private RelativeLayout iconBrushLayout;
    @Nullable
    private ImageView iconBrush;
    @Nullable
    private ImageView iconMagnify;
    @Nullable
    private ImageView iconBlur;
    @Nullable
    private ImageView iconUndo;
    @Nullable
    private View brushIndicator;
    @Nullable
    private View border;
    @Nullable
    private ShapeSuggestionsLayout shapeSuggestionsLayout;

    public AnnotationLayout(Context context) {
        this(context, null);
    }

    public AnnotationLayout(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationLayout(Context context, @Nullable AttributeSet attributeSet, int n) {
        AnnotationLayout annotationLayout = this;
        super(context, attributeSet, n);
        annotationLayout.initViews();
        annotationLayout.configureViews();
    }

    @TargetApi(value=21)
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationLayout(Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        AnnotationLayout annotationLayout = this;
        super(context, attributeSet, n, n2);
        annotationLayout.initViews();
        annotationLayout.configureViews();
    }

    private void initViews() {
        View.inflate((Context)this.getContext(), (int)R.layout.instabug_annotation_view, (ViewGroup)this);
        this.annotationActionsContainer = (LinearLayout)this.findViewById(R.id.instabug_annotation_actions_container);
        this.shapeSuggestionsLayout = (ShapeSuggestionsLayout)this.findViewById(R.id.shapeSuggestionsLayout);
        this.iconBrushLayout = (RelativeLayout)this.findViewById(R.id.icon_brush_layout);
        this.iconBrush = (ImageView)this.findViewById(R.id.icon_brush);
        this.iconMagnify = (ImageView)this.findViewById(R.id.icon_magnify);
        this.iconBlur = (ImageView)this.findViewById(R.id.icon_blur);
        this.iconUndo = (ImageView)this.findViewById(R.id.icon_undo);
        this.border = this.findViewById(R.id.instabug_annotation_image_border);
        this.mAnnotationView = (AnnotationView)this.findViewById(R.id.instabug_annotation_image);
        this.colorPicker = (ColorPickerPopUpView)this.findViewById(R.id.instabug_color_picker);
        this.brushIndicator = this.findViewById(R.id.brush_indicator);
    }

    private void configureViews() {
        Object object = this.shapeSuggestionsLayout;
        if (object != null) {
            object.setOnShapeSelectedListener(n -> {
                if (n == 1 && (this = ((AnnotationLayout)((Object)((Object)this))).mAnnotationView) != null) {
                    ((AnnotationView)((Object)((Object)this))).setRecognizedShape();
                }
            });
        }
        AnnotationLayout annotationLayout = this;
        annotationLayout.setAnnotationButtonsEnabled(false);
        annotationLayout.configureBrushIconAccessibility();
        annotationLayout.configureAnnotationView(annotationLayout.mAnnotationView);
        object = annotationLayout.colorPicker;
        if (object != null) {
            ((ColorPickerPopUpView)((Object)object)).setPopUpBackgroundColor(AttrResolver.resolveAttributeColor((Context)this.getContext(), (int)R.attr.ib_annotation_color_picker_bg_color));
        }
        AnnotationLayout annotationLayout2 = this;
        annotationLayout2.registerAnnotationIconsClickListeners();
        annotationLayout2.setViewSelector(annotationLayout2.iconMagnify);
        annotationLayout2.setViewSelector(annotationLayout2.iconUndo);
        annotationLayout2.tintingColor = ContextCompat.getColor((Context)annotationLayout2.getContext(), (int)R.color.ib_core_annotation_tinting_color);
    }

    private void configureAnnotationView(@Nullable AnnotationView annotationView) {
        if (annotationView == null) {
            return;
        }
        annotationView.setDrawingMode(AnnotationView.DrawingMode.DRAW_PATH);
        Object object = this.iconBrush;
        if (object != null) {
            DrawableUtils.setDrawableTintColor((ImageView)object, (int)InstabugCore.getPrimaryColor());
        }
        if ((object = this.colorPicker) != null) {
            annotationView.setDrawingColor(((ColorPickerPopUpView)((Object)object)).getSelectedColor());
        }
        annotationView.setOnActionDownListener(() -> {
            ColorPickerPopUpView colorPickerPopUpView = this.colorPicker;
            if (colorPickerPopUpView != null && colorPickerPopUpView.getVisibility() == 0) {
                this.colorPicker.setVisibility(8);
            }
            if ((this = this.shapeSuggestionsLayout) != null) {
                this.hide();
            }
        });
        annotationView.setOnPathRecognizedListener((path, path2) -> {
            Path[] pathArray2 = this;
            Path[] pathArray3 = new Path[2];
            this = pathArray3;
            pathArray3[0] = path;
            pathArray3[1] = path2;
            super.showShapeSuggestions((Path)this);
        });
        annotationView.setOnNewMagnifierAddingAbilityChangedListener(bl -> {
            AnnotationLayout annotationLayout = annotationLayout.iconMagnify;
            if (annotationLayout != null) {
                annotationLayout.setEnabled(bl);
            }
        });
        object = this.colorPicker;
        if (object == null) {
            return;
        }
        ((ColorPickerPopUpView)((Object)object)).setOnColorSelectionListener((n, n2) -> {
            annotationView.setDrawingColor(n);
            annotationView = this.colorPicker;
            if (annotationView != null) {
                annotationView.setVisibility(8);
            }
            if ((this = this.brushIndicator) != null) {
                this.setBackgroundColor(n);
            }
        });
    }

    private void showShapeSuggestions(Path ... pathArray) {
        ShapeSuggestionsLayout shapeSuggestionsLayout = this.shapeSuggestionsLayout;
        if (shapeSuggestionsLayout != null) {
            shapeSuggestionsLayout.removeAllViews();
            for (int i = 0; i < pathArray.length; ++i) {
                ShapeSuggestionsLayout shapeSuggestionsLayout2 = this.shapeSuggestionsLayout;
                int n = i == 0 ? R.string.ibg_bug_annotation_original_shape_content_description : R.string.ibg_bug_annotation_recognized_shape_content_description;
                shapeSuggestionsLayout2.addShapeSuggestion(n, pathArray[i]);
            }
            this.shapeSuggestionsLayout.show();
        }
    }

    private void setBorder() {
        ShapeDrawable shapeDrawable;
        AnnotationLayout annotationLayout = this;
        int n = ViewUtils.convertDpToPx((Context)annotationLayout.getContext(), (float)4.0f);
        int n2 = ViewUtils.convertDpToPx((Context)annotationLayout.getContext(), (float)2.0f);
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        new ShapeDrawable().setShape((Shape)new RectShape());
        shapeDrawable2.getPaint().setColor(InstabugCore.getPrimaryColor());
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setStrokeWidth((float)n);
        View view = annotationLayout.border;
        if (view != null) {
            int n3 = n2;
            view.setPadding(n3, n3, n3, n3);
            if (Build.VERSION.SDK_INT >= 16) {
                this.border.setBackground((Drawable)shapeDrawable2);
            } else {
                this.border.setBackgroundDrawable((Drawable)shapeDrawable2);
            }
        }
    }

    private void setViewSelector(@Nullable ImageView imageView) {
        if (imageView != null) {
            imageView.setOnTouchListener((view, motionEvent) -> {
                if (motionEvent.getAction() == 0) {
                    DrawableUtils.setDrawableTintColor((ImageView)imageView, (int)InstabugCore.getPrimaryColor());
                } else if (motionEvent.getAction() == 1) {
                    DrawableUtils.setDrawableTintColor((ImageView)imageView, (int)this.tintingColor);
                }
                return false;
            });
        }
    }

    private void switchColorPickerVisibility() {
        Object object = object.colorPicker;
        if (object != null) {
            int n = object.getVisibility() == 0 ? 8 : 0;
            object.setVisibility(n);
        }
    }

    private void hideColorPicker() {
        ColorPickerPopUpView colorPickerPopUpView = this.colorPicker;
        if (colorPickerPopUpView != null && colorPickerPopUpView.getVisibility() == 0) {
            this.colorPicker.setVisibility(8);
        }
    }

    private void resetColorSelection() {
        LinearLayout linearLayout = this.annotationActionsContainer;
        if (linearLayout != null) {
            int n = linearLayout.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (!(this.annotationActionsContainer.getChildAt(i) instanceof IconView)) continue;
                ((TextView)this.annotationActionsContainer.getChildAt(i)).setTextColor(this.tintingColor);
            }
        }
        AnnotationLayout annotationLayout = this;
        DrawableUtils.setDrawableTintColor((ImageView)annotationLayout.iconBrush, (int)this.tintingColor);
        DrawableUtils.setDrawableTintColor((ImageView)annotationLayout.iconBlur, (int)this.tintingColor);
    }

    private void registerAnnotationIconsClickListeners() {
        RelativeLayout relativeLayout = this.iconBrushLayout;
        if (relativeLayout != null) {
            relativeLayout.setOnClickListener((View.OnClickListener)this);
        }
        if ((relativeLayout = this.iconMagnify) != null) {
            relativeLayout.setOnClickListener((View.OnClickListener)this);
        }
        if ((relativeLayout = this.iconBlur) != null) {
            relativeLayout.setOnClickListener((View.OnClickListener)this);
        }
        if ((relativeLayout = this.iconUndo) != null) {
            relativeLayout.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setAnnotationButtonsEnabled(boolean bl) {
        ImageView imageView = this.iconBrush;
        if (imageView != null) {
            imageView.setEnabled(bl);
        }
        if ((imageView = this.iconMagnify) != null) {
            imageView.setEnabled(bl);
        }
        if ((imageView = this.iconBlur) != null) {
            imageView.setEnabled(bl);
        }
        if ((this = this.iconUndo) != null) {
            this.setEnabled(bl);
        }
    }

    private void configureBrushIconAccessibility() {
        if (this.iconBrush != null && AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setAccessibilityDelegate((View)this.iconBrush, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
                }
            });
        }
    }

    public void onClick(View view) {
        int n;
        ShapeSuggestionsLayout shapeSuggestionsLayout = this.shapeSuggestionsLayout;
        if (shapeSuggestionsLayout != null) {
            shapeSuggestionsLayout.hide();
        }
        if ((n = view.getId()) == R.id.icon_brush_layout) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.switchColorPickerVisibility();
            AnnotationView annotationView = annotationLayout.mAnnotationView;
            if (annotationView != null) {
                annotationView.setDrawingMode(AnnotationView.DrawingMode.DRAW_PATH);
            }
            AnnotationLayout annotationLayout2 = this;
            annotationLayout2.resetColorSelection();
            DrawableUtils.setDrawableTintColor((ImageView)annotationLayout2.iconBrush, (int)InstabugCore.getPrimaryColor());
        } else if (n == R.id.icon_magnify) {
            AnnotationView annotationView = this.mAnnotationView;
            if (annotationView != null) {
                annotationView.addMagnifier();
            }
            this.hideColorPicker();
        } else if (n == R.id.icon_blur) {
            AnnotationView annotationView = this.mAnnotationView;
            if (annotationView != null) {
                annotationView.setDrawingMode(AnnotationView.DrawingMode.DRAW_BLUR);
            }
            AnnotationLayout annotationLayout = this;
            annotationLayout.resetColorSelection();
            DrawableUtils.setDrawableTintColor((ImageView)annotationLayout.iconBlur, (int)InstabugCore.getPrimaryColor());
            annotationLayout.hideColorPicker();
        } else if (n == R.id.icon_undo) {
            AnnotationView annotationView = this.mAnnotationView;
            if (annotationView != null) {
                annotationView.undo();
            }
            this.hideColorPicker();
        }
    }

    public void setBaseImage(@NonNull Uri uri, @Nullable Runnable runnable) {
        if (uri.getPath() != null && object.mAnnotationView != null) {
            AnnotationLayout annotationLayout = object;
            Object object = object.mAnnotationView;
            BitmapUtils.loadBitmap((String)uri.getPath(), (ImageView)object, () -> {
                AnnotationLayout annotationLayout = this;
                annotationLayout.setAnnotationButtonsEnabled(true);
                annotationLayout.setBorder();
                if (runnable != null) {
                    runnable.run();
                }
            });
        }
    }

    public void setBitmap(Bitmap bitmap) {
        AnnotationView annotationView = this.mAnnotationView;
        if (annotationView != null) {
            annotationView.setImageBitmap(bitmap);
        }
        AnnotationLayout annotationLayout = this;
        annotationLayout.setAnnotationButtonsEnabled(true);
        annotationLayout.setBorder();
    }

    @Nullable
    public Bitmap getAnnotatedBitmap() {
        Object object = object.mAnnotationView;
        if (object != null) {
            return ((AnnotationView)((Object)object)).toBitmap();
        }
        return null;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle.putParcelable("instabug_annotation_layout", super.onSaveInstanceState());
        AnnotationView annotationView = ((AnnotationLayout)((Object)annotationView)).mAnnotationView;
        if (annotationView != null) {
            bundle2.putSerializable("drawingMode", (Serializable)annotationView.getDrawingMode());
        }
        return bundle2;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        ColorPickerPopUpView colorPickerPopUpView;
        AnnotationView annotationView = this.mAnnotationView;
        if (annotationView != null && (colorPickerPopUpView = this.colorPicker) != null) {
            annotationView.setDrawingColor(colorPickerPopUpView.getSelectedColor());
            if (parcelable instanceof Bundle) {
                parcelable = (Bundle)parcelable;
                AnnotationView.DrawingMode drawingMode = (AnnotationView.DrawingMode)parcelable.getSerializable("drawingMode");
                this.resetColorSelection();
                if (drawingMode == AnnotationView.DrawingMode.DRAW_BLUR) {
                    DrawableUtils.setDrawableTintColor((ImageView)this.iconBlur, (int)InstabugCore.getPrimaryColor());
                } else {
                    DrawableUtils.setDrawableTintColor((ImageView)this.iconBrush, (int)InstabugCore.getPrimaryColor());
                }
                parcelable = parcelable.getParcelable("instabug_annotation_layout");
            }
            if (parcelable != null) {
                super.onRestoreInstanceState(parcelable);
            }
        }
    }
}

