/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.reporting;

import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionConfig;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.instabug.bug.R;
import com.instabug.bug.view.disclaimer.Disclaimer;
import com.instabug.bug.view.disclaimer.DisclaimerDetailsFragment;
import com.instabug.bug.view.disclaimer.DisclaimerFragment;
import com.instabug.bug.view.extrafields.ExtraFieldsFragment;
import com.instabug.bug.view.reporting.BaseReportingFragment;
import com.instabug.bug.view.reporting.askquestion.AskQuestionFragment;
import com.instabug.bug.view.reporting.bugreporting.BugReportingFragment;
import com.instabug.bug.view.reporting.feedback.FeedbackFragment;
import com.instabug.bug.view.reporting.frustratingexperience.FrustratingExperienceFragment;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepPreviewFragment;
import com.instabug.bug.view.visualusersteps.visitedscreens.VisualUserStepsListFragment;
import com.instabug.common.photopicker.PhotoPickerActivity;
import com.instabug.library.R;
import com.instabug.library.internal.InstabugMediaProjectionIntent;

abstract class ReportingNavigator {
    static void navigateToBugReportingFragment(FragmentManager fragmentManager, @Nullable String string2, boolean bl) {
        int n = R.id.instabug_fragment_container;
        BugReportingFragment bugReportingFragment = BugReportingFragment.newInstance(string2);
        string2 = BugReportingFragment.TAG;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)bugReportingFragment, string2, bl);
    }

    static void navigateToFeedbackReportingFragment(FragmentManager fragmentManager, @Nullable String string2, boolean bl) {
        int n = R.id.instabug_fragment_container;
        FeedbackFragment feedbackFragment = FeedbackFragment.newInstance(string2);
        string2 = FeedbackFragment.TAG;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)feedbackFragment, string2, bl);
    }

    static void navigateToAskQuestion(FragmentManager fragmentManager, @Nullable String string2, boolean bl) {
        int n = R.id.instabug_fragment_container;
        AskQuestionFragment askQuestionFragment = AskQuestionFragment.newInstance(string2);
        string2 = AskQuestionFragment.TAG;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)askQuestionFragment, string2, bl);
    }

    static void navigateToFrustratingExperience(FragmentManager fragmentManager, @Nullable String string2, boolean bl) {
        int n = R.id.instabug_fragment_container;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)FrustratingExperienceFragment.newInstance(string2), "FrustratingExperienceFragment", bl);
    }

    static void navigateToDisclaimerFragment(FragmentManager fragmentManager, boolean bl) {
        ReportingNavigator.replaceFragment(fragmentManager, R.id.instabug_fragment_container, (Fragment)DisclaimerFragment.newInstance(), "disclaimer", bl);
    }

    static void navigateToDisclaimerDetailsFragment(FragmentManager fragmentManager, Disclaimer disclaimer) {
        int n = R.id.instabug_fragment_container;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)DisclaimerDetailsFragment.newInstance(disclaimer), "disclaimer_details", true);
    }

    static void navigateToVisualUserStepPreview(FragmentManager fragmentManager, @NonNull VisualUserStepArgs visualUserStepArgs) {
        int n = R.id.instabug_fragment_container;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)VisualUserStepPreviewFragment.newInstance(visualUserStepArgs), "visual_user_step_preview", true);
    }

    static void navigateToVisualUserStepListFragment(FragmentManager fragmentManager, String string2) {
        int n = R.id.instabug_fragment_container;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)VisualUserStepsListFragment.newInstance(string2), "visual_user_steps", true);
    }

    @RequiresApi(api=21)
    static void requestRecordingPermission(@NonNull MediaProjectionManager mediaProjectionManager, BaseReportingFragment baseReportingFragment) {
        if (baseReportingFragment == null) {
            return;
        }
        if (InstabugMediaProjectionIntent.isMediaProjectionIntentReadyToUse()) {
            baseReportingFragment.openVideoRecorder();
        } else if (baseReportingFragment.getContext() != null && InstabugMediaProjectionIntent.canStartMediaProjectionFGService((Context)baseReportingFragment.getContext())) {
            mediaProjectionManager = Build.VERSION.SDK_INT >= 34 ? mediaProjectionManager.createScreenCaptureIntent(MediaProjectionConfig.createConfigForDefaultDisplay()) : mediaProjectionManager.createScreenCaptureIntent();
            baseReportingFragment.startActivityForResult((Intent)mediaProjectionManager, 3890);
        }
    }

    private static void replaceFragment(FragmentManager fragmentManager, @IdRes int n, Fragment fragment, @Nullable String string2, boolean bl) {
        fragmentManager = fragmentManager.beginTransaction().replace(n, fragment, string2);
        if (bl) {
            fragmentManager.addToBackStack(string2);
        }
        fragmentManager.commitAllowingStateLoss();
    }

    static void navigateToExtraFields(FragmentManager fragmentManager, @Nullable String string2) {
        int n = R.id.instabug_fragment_container;
        ReportingNavigator.replaceFragment(fragmentManager, n, (Fragment)ExtraFieldsFragment.newInstance(string2), "ExtraFieldsFragment", true);
    }

    static void navigateToPhotoPicker(BaseReportingFragment baseReportingFragment) {
        Context context = baseReportingFragment.getContext();
        if (context != null) {
            Intent intent;
            BaseReportingFragment baseReportingFragment2 = baseReportingFragment;
            baseReportingFragment = intent;
            intent = new Intent(context, PhotoPickerActivity.class);
            baseReportingFragment2.openActivityForResult((Intent)baseReportingFragment, 3862);
        }
    }
}

