/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenshot.viewhierarchy;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.instabug.bug.screenshot.viewhierarchy.ViewHierarchy;
import com.instabug.library.R;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ViewHierarchyInspector {
    public static ReturnableExecutable<ViewHierarchy> getInspectRootViewExecutable(final ViewHierarchy viewHierarchy) {
        return new ReturnableExecutable<ViewHierarchy>(){

            public ViewHierarchy execute() {
                return ViewHierarchyInspector.inspectVisibleView(viewHierarchy);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ViewHierarchy inspectVisibleView(ViewHierarchy viewHierarchy) {
        JSONException jSONException2;
        block3: {
            if (viewHierarchy.getView() == null) return viewHierarchy;
            if (viewHierarchy.getView().getVisibility() != 0) return viewHierarchy;
            try {
                ViewHierarchy viewHierarchy2 = viewHierarchy;
                viewHierarchy2.setType(ViewHierarchyInspector.inspectViewType(viewHierarchy2.getView()));
                viewHierarchy2.setIconIdentifier(ViewHierarchyInspector.obtainViewIcon(viewHierarchy2.getView()));
                viewHierarchy2.setProperties(ViewHierarchyInspector.inspectViewProperties(viewHierarchy2.getView()));
                viewHierarchy2.setOriginalRect(ViewHierarchyInspector.inspectViewOriginalRect(viewHierarchy2.getView()));
                viewHierarchy2.setVisibleRect(ViewHierarchyInspector.inspectViewVisibleRect(viewHierarchy2));
                viewHierarchy2.setFrame(ViewHierarchyInspector.inspectViewFrame(viewHierarchy2));
                if (viewHierarchy2.getView() instanceof ViewGroup) {
                    ViewHierarchy viewHierarchy3 = viewHierarchy;
                    viewHierarchy3.setHasChildren(true);
                    ViewHierarchyInspector.inspectViewChildren(viewHierarchy3);
                    return viewHierarchy;
                }
            }
            catch (JSONException jSONException2) {
                break block3;
            }
            viewHierarchy.setHasChildren(false);
            return viewHierarchy;
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)("inspect view hierarchy got error: " + jSONException2.getMessage() + ",View hierarchy id:" + viewHierarchy.getId()), (Throwable)jSONException2);
        return viewHierarchy;
    }

    private static void inspectViewChildren(ViewHierarchy viewHierarchy) {
        if (viewHierarchy.getView() instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)viewHierarchy.getView();
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                ViewHierarchy viewHierarchy2;
                ViewHierarchy viewHierarchy3;
                if (viewGroup.getChildAt(i).getId() == R.id.instabug_extra_screenshot_button || viewGroup.getChildAt(i).getId() == R.id.instabug_floating_button) continue;
                ViewHierarchy viewHierarchy4 = viewHierarchy3 = viewHierarchy2;
                viewHierarchy4();
                viewHierarchy4.setRoot(false);
                viewHierarchy4.setId(viewHierarchy.getId() + "-" + i);
                viewHierarchy3.setView(viewGroup.getChildAt(i));
                viewHierarchy3.setParent(viewHierarchy);
                viewHierarchy2.setScale(viewHierarchy.getScale());
                viewHierarchy.addNode(ViewHierarchyInspector.inspectVisibleView(viewHierarchy2));
            }
        }
    }

    private static String obtainViewIcon(View view) {
        String string2 = view.getClass().getSimpleName();
        if (!string2.equals("ProgressBar")) {
            if (!string2.equals("WebView")) {
                if (!string2.equals("MultiAutoCompleteTextView")) {
                    if (!string2.equals("HorizontalScrollView")) {
                        if (!string2.equals("VideoView")) {
                            if (!string2.equals("TextView")) {
                                if (!string2.equals("ImageButton")) {
                                    if (!string2.equals("TableRow")) {
                                        if (!string2.equals("RelativeLayout")) {
                                            if (!string2.equals("GridView")) {
                                                if (!string2.equals("RadioButton")) {
                                                    if (!string2.equals("ToggleButton")) {
                                                        if (!string2.equals("ImageView")) {
                                                            if (!string2.equals("LinearLayout")) {
                                                                if (!string2.equals("SearchView")) {
                                                                    if (!string2.equals("FrameLayout")) {
                                                                        if (!string2.equals("ListView")) {
                                                                            if (!string2.equals("AutoCompleteTextView")) {
                                                                                if (!string2.equals("EditText")) {
                                                                                    if (!string2.equals("TableLayout")) {
                                                                                        if (!string2.equals("Button")) {
                                                                                            if (!string2.equals("ScrollView")) {
                                                                                                return "default";
                                                                                            }
                                                                                            return "ScrollView";
                                                                                        }
                                                                                        return "Button";
                                                                                    }
                                                                                    return "TableLayout";
                                                                                }
                                                                                return "EditText";
                                                                            }
                                                                            return "AutoCompleteTextView";
                                                                        }
                                                                        return "ListView";
                                                                    }
                                                                    return "FrameLayout";
                                                                }
                                                                return "SearchView";
                                                            }
                                                            if (((LinearLayout)view).getOrientation() == 0) {
                                                                return "HorizontalLinearLayout";
                                                            }
                                                            return "VerticalLinearLayout";
                                                        }
                                                        return "ImageView";
                                                    }
                                                    return "ToggleButton";
                                                }
                                                return "RadioButton";
                                            }
                                            return "GridView";
                                        }
                                        return "RelativeLayout";
                                    }
                                    return "TableRow";
                                }
                                return "ImageButton";
                            }
                            return "TextView";
                        }
                        return "VideoView";
                    }
                    return "HorizontalScrollView";
                }
                return "MultiAutoCompleteTextView";
            }
            return "WebView";
        }
        return "ProgressBar";
    }

    private static String inspectViewType(View view) {
        return view.getClass().getSimpleName();
    }

    private static JSONObject inspectViewProperties(View view) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject.put("resource_id", (Object)ViewHierarchyInspector.inspectViewResourceId(view.getContext(), view.getId())).put("height", view.getHeight()).put("width", view.getWidth()).put("padding_top", view.getPaddingTop()).put("padding_bottom", view.getPaddingBottom()).put("padding_right", view.getPaddingRight()).put("padding_left", view.getPaddingLeft()).put("visibility", view.getVisibility());
        if (Build.VERSION.SDK_INT >= 17) {
            jSONObject2.put("padding_end", view.getPaddingEnd()).put("padding_start", view.getPaddingStart());
        }
        double d = view.getX();
        JSONObject jSONObject3 = jSONObject2.put("x", d);
        d = view.getY();
        jSONObject3.put("y", d);
        if (view.getLayoutParams() instanceof LinearLayout.LayoutParams) {
            ViewHierarchyInspector.inspectLinearLayoutParams((LinearLayout.LayoutParams)view.getLayoutParams(), jSONObject2);
        } else if (view.getLayoutParams() instanceof FrameLayout.LayoutParams) {
            ViewHierarchyInspector.inspectFrameLayoutParams((FrameLayout.LayoutParams)view.getLayoutParams(), jSONObject2);
        } else if (view.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            ViewHierarchyInspector.inspectRelativeLayoutParams(view.getContext(), (RelativeLayout.LayoutParams)view.getLayoutParams(), jSONObject2);
        }
        return jSONObject2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String inspectViewResourceId(Context var0, int var1_1) {
        if (var1_1 == -1) {
            return String.valueOf(var1_1);
        }
        if (var0 /* !! */  == null) ** GOTO lbl-1000
        try {
            if (var0 /* !! */ .getResources() != null && var0 /* !! */ .getResources().getResourceEntryName(var1_1) != null) {
                v0 = var0 /* !! */ .getResources().getResourceEntryName(var1_1);
                return v0;
            }
        }
        catch (Resources.NotFoundException v1) {
            return String.valueOf(var1_1);
        }
lbl-1000:
        // 2 sources

        {
            v0 = String.valueOf(var1_1);
            return v0;
        }
    }

    private static void inspectLinearLayoutParams(LinearLayout.LayoutParams layoutParams, JSONObject jSONObject) {
        jSONObject.put("gravity", layoutParams.gravity).put("margin_top", layoutParams.topMargin).put("margin_bottom", layoutParams.bottomMargin).put("margin_left", layoutParams.leftMargin).put("margin_right", layoutParams.rightMargin);
    }

    private static void inspectFrameLayoutParams(FrameLayout.LayoutParams layoutParams, JSONObject jSONObject) {
        jSONObject.put("gravity", layoutParams.gravity).put("margin_top", layoutParams.topMargin).put("margin_bottom", layoutParams.bottomMargin).put("margin_left", layoutParams.leftMargin).put("margin_right", layoutParams.rightMargin);
    }

    private static void inspectRelativeLayoutParams(Context context, RelativeLayout.LayoutParams object, JSONObject jSONObject) {
        jSONObject.put("margin_top", object.topMargin).put("margin_bottom", object.bottomMargin).put("margin_left", object.leftMargin).put("margin_right", object.rightMargin);
        object = object.getRules();
        for (int i = 0; i < ((RelativeLayout.LayoutParams)object).length; ++i) {
            RelativeLayout.LayoutParams layoutParams = object[i];
            String string2 = layoutParams > 0 ? ViewHierarchyInspector.inspectViewResourceId(context, (int)layoutParams) : String.valueOf((int)layoutParams);
            jSONObject.put(ViewHierarchyInspector.inspectRelativeLayoutParamRuleVerb(i), (Object)string2);
        }
    }

    private static String inspectRelativeLayoutParamRuleVerb(int n) {
        switch (n) {
            default: {
                return "notIdentified";
            }
            case 21: {
                return "alignParentEnd";
            }
            case 20: {
                return "alignParentStart";
            }
            case 19: {
                return "alignEnd";
            }
            case 18: {
                return "alignStart";
            }
            case 16: {
                return "startOf";
            }
            case 15: {
                return "centerVertical";
            }
            case 14: {
                return "centerHorizontal";
            }
            case 13: {
                return "centerInParent";
            }
            case 12: {
                return "alignParentBottom";
            }
            case 11: {
                return "alignParentRight";
            }
            case 10: {
                return "alignParentTop";
            }
            case 9: {
                return "alignParentLeft";
            }
            case 8: {
                return "alignBottom";
            }
            case 7: {
                return "alignRight";
            }
            case 6: {
                return "alignTop";
            }
            case 5: {
                return "alignLeft";
            }
            case 4: {
                return "alignBaseline";
            }
            case 3: {
                return "below";
            }
            case 2: {
                return "above";
            }
            case 1: {
                return "rightOf";
            }
            case 0: 
        }
        return "leftOf";
    }

    private static Rect inspectViewOriginalRect(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n + view.getWidth();
        int n4 = nArray[1] + view.getHeight();
        return new Rect(n, n2, n3, n4);
    }

    @Nullable
    private static Rect inspectViewVisibleRect(ViewHierarchy viewHierarchy) {
        if (viewHierarchy.isRoot()) {
            return viewHierarchy.getOriginalRect();
        }
        if (viewHierarchy.getOriginalRect() != null && viewHierarchy.getParent() != null) {
            Rect rect;
            Rect rect2 = rect;
            ViewHierarchy viewHierarchy2 = viewHierarchy;
            int n = viewHierarchy2.getOriginalRect().top;
            int n2 = viewHierarchy2.getOriginalRect().right;
            int n3 = viewHierarchy2.getOriginalRect().bottom;
            rect = new Rect(viewHierarchy.getOriginalRect().left, n, n2, n3);
            ViewHierarchy viewHierarchy3 = viewHierarchy;
            int n4 = ViewHierarchyInspector.inspectViewAvailableY(viewHierarchy3.getParent());
            n = ViewHierarchyInspector.inspectViewAvailableRight(viewHierarchy3.getParent());
            n2 = ViewHierarchyInspector.inspectViewAvailableBottom(viewHierarchy3.getParent());
            if (rect.intersect(new Rect(ViewHierarchyInspector.inspectViewAvailableX(viewHierarchy.getParent()), n4, n, n2))) {
                return rect2;
            }
            return new Rect(0, 0, 0, 0);
        }
        return new Rect(0, 0, 0, 0);
    }

    private static int inspectViewAvailableX(ViewHierarchy viewHierarchy) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (viewHierarchy.getVisibleRect() != null) {
            n = viewHierarchy.getVisibleRect().left;
        }
        if (viewHierarchy.getView() != null) {
            n2 = viewHierarchy.getView().getPaddingLeft();
        }
        if (viewHierarchy.getOriginalRect() != null) {
            n3 = viewHierarchy.getOriginalRect().left;
        }
        if (n2 == 0) {
            return n;
        }
        return Math.max(n, n3 + n2);
    }

    private static int inspectViewAvailableY(ViewHierarchy viewHierarchy) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (viewHierarchy.getVisibleRect() != null) {
            n = viewHierarchy.getVisibleRect().top;
        }
        if (viewHierarchy.getView() != null) {
            n2 = viewHierarchy.getView().getPaddingTop();
        }
        if (viewHierarchy.getOriginalRect() != null) {
            n3 = viewHierarchy.getOriginalRect().top;
        }
        if (n2 == 0) {
            return n;
        }
        return Math.max(n, n3 + n2);
    }

    private static int inspectViewAvailableRight(ViewHierarchy viewHierarchy) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (viewHierarchy.getVisibleRect() != null) {
            n = viewHierarchy.getVisibleRect().right;
        }
        if (viewHierarchy.getView() != null) {
            n2 = viewHierarchy.getView().getPaddingRight();
        }
        if (viewHierarchy.getOriginalRect() != null) {
            n3 = viewHierarchy.getOriginalRect().right;
        }
        if (n2 == 0) {
            return n;
        }
        return Math.min(n, n3 - n2);
    }

    private static int inspectViewAvailableBottom(ViewHierarchy viewHierarchy) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (viewHierarchy.getVisibleRect() != null) {
            n = viewHierarchy.getVisibleRect().bottom;
        }
        if (viewHierarchy.getView() != null) {
            n2 = viewHierarchy.getView().getPaddingBottom();
        }
        if (viewHierarchy.getOriginalRect() != null) {
            n3 = viewHierarchy.getOriginalRect().bottom;
        }
        if (n2 == 0) {
            return n;
        }
        return Math.min(n, n3 - n2);
    }

    @Nullable
    private static JSONObject inspectViewFrame(ViewHierarchy viewHierarchy) {
        if (viewHierarchy.getVisibleRect() != null) {
            return new JSONObject().put("x", viewHierarchy.getVisibleRect().left / viewHierarchy.getScale()).put("y", viewHierarchy.getVisibleRect().top / viewHierarchy.getScale()).put("w", viewHierarchy.getVisibleRect().width() / viewHierarchy.getScale()).put("h", viewHierarchy.getVisibleRect().height() / viewHierarchy.getScale());
        }
        return null;
    }

    public static JSONObject inspectRootViewFrame(Activity activity, int n) {
        return new JSONObject().put("w", activity.getWindow().getDecorView().getWidth() / n).put("h", activity.getWindow().getDecorView().getHeight() / n);
    }

    public static List<ViewHierarchy> convertViewHierarchyToList(ViewHierarchy object) {
        ArrayList<ViewHierarchy> arrayList;
        ArrayList<ViewHierarchy> arrayList2 = arrayList;
        arrayList = new ArrayList<ViewHierarchy>();
        if (object != null) {
            arrayList2.add((ViewHierarchy)object);
            if (((ViewHierarchy)object).hasChildren()) {
                object = ((ViewHierarchy)object).getNodes().iterator();
                while (object.hasNext()) {
                    arrayList2.addAll(ViewHierarchyInspector.convertViewHierarchyToList((ViewHierarchy)object.next()));
                }
            }
        }
        return arrayList2;
    }

    public static enum Action {
        STARTED,
        FAILED,
        COMPLETED;

    }
}

