/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.invocation.InvocationListener;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.bug.ui.promptoptions.PromptOptionsLauncher;
import com.instabug.library.Instabug;
import com.instabug.library.core.InitialScreenshotHelper;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.core.plugin.PromptOptionManager;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;

public class InvocationRequestListenerImp
implements InvocationListener {
    private boolean isInitialScreenshotIsRequired() {
        if (SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled()) {
            InvocationRequestListenerImp invocationRequestListenerImp = Instabug.getApplicationContext();
            if (invocationRequestListenerImp != null) {
                return SettingsManager.isInitialScreenShotAllowed() && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable((Context)invocationRequestListenerImp);
            }
            return false;
        }
        return SettingsManager.isInitialScreenShotAllowed();
    }

    private void handleInvocationRequest(@Nullable Uri uri) {
        int n = this.getInvocationMode();
        if (n == 4) {
            this.invokeWithoutScreenshot(2);
            return;
        }
        if (uri == null && this.isInitialScreenshotIsRequired()) {
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    InvocationRequestListenerImp invocationRequestListenerImp = this;
                    invocationRequestListenerImp.startPreInvocationRunnable();
                    invocationRequestListenerImp.captureScreenshotThenInvoke((PluginPromptOption)InstabugCore.getPluginsPromptOptions().get(0));
                    break;
                }
                case 0: {
                    InvocationRequestListenerImp invocationRequestListenerImp = this;
                    invocationRequestListenerImp.startPreInvocationRunnable();
                    invocationRequestListenerImp.captureScreenshotThenLaunchPromptOptions();
                    break;
                }
            }
        } else {
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.startPreInvocationRunnable();
                    this.invoke(uri, (PluginPromptOption)InstabugCore.getPluginsPromptOptions().get(0));
                    break;
                }
                case 0: {
                    InvocationRequestListenerImp invocationRequestListenerImp = this;
                    invocationRequestListenerImp.startPreInvocationRunnable();
                    invocationRequestListenerImp.launchPromptOptionActivity(uri);
                }
            }
        }
    }

    private void invokeWithoutScreenshot(@PluginPromptOption.PromptOptionIdentifier int n) {
        PluginPromptOption pluginPromptOption = PromptOptionManager.getPluginByIdentifier((int)n, (boolean)false);
        if (pluginPromptOption != null) {
            this.invoke(null, pluginPromptOption);
        }
    }

    private void startPreInvocationRunnable() {
        if (SettingsManager.getInstance().getOnInvokeCallback() != null) {
            SettingsManager.getInstance().getOnInvokeCallback().onInvoke();
        }
    }

    @Override
    public void onInvocationRequested(@Nullable Uri uri) {
        this.handleInvocationRequested(uri);
    }

    @Override
    public void onInvocationRequested() {
        this.handleInvocationRequested(null);
    }

    @VisibleForTesting
    int getInvocationMode() {
        ArrayList arrayList = InstabugCore.getPluginsPromptOptions();
        if (arrayList.size() > 1) {
            return 0;
        }
        if (!arrayList.isEmpty()) {
            switch (((PluginPromptOption)arrayList.get(0)).getPromptOptionIdentifier()) {
                default: {
                    return -1;
                }
                case 3: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
                case 1: {
                    return 2;
                }
                case 0: 
            }
            return 1;
        }
        return -1;
    }

    @SuppressLint(value={"SwitchIntDef"})
    @VisibleForTesting
    void handleInvocationRequested(@Nullable Uri uri) {
        if (InstabugCore.getRunningSession() == null) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)("handleInvocationRequested() called with: screenShotUri = [" + uri + "] but session is not started yet!"));
            return;
        }
        if (!InstabugCore.isForegroundNotBusy()) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)("handleInvocationRequested() called with: screenShotUri = [" + uri + "] but SDK is Busy"));
            return;
        }
        this.handleInvocationRequest(uri);
    }

    @VisibleForTesting
    void invoke(@Nullable Uri uri, @NonNull PluginPromptOption object) {
        InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationRequestListenerImp#invoke] invoking...");
        Object object2 = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (object2 == null) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationRequestListenerImp#invoke] CurrentActivity is null, returning...");
            return;
        }
        InstabugDialogItem instabugDialogItem = PromptOptionsLauncher.getInstance().getItem((PluginPromptOption)object, null);
        if (instabugDialogItem != null && instabugDialogItem.getSubItems() != null && !instabugDialogItem.getSubItems().isEmpty()) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationRequestListenerImp#invoke] Launching prompt options");
            InvocationRequestListenerImp invocationRequestListenerImp = object2;
            object2 = object.getTitle();
            object = instabugDialogItem.getSubItems();
            PromptOptionsLauncher.getInstance().launchPromptOptionsActivity((Activity)invocationRequestListenerImp, uri, (String)object2, (ArrayList<InstabugDialogItem>)object);
        } else {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationRequestListenerImp#invoke] invoking directly");
            object.invoke(uri, new String[0]);
        }
    }

    @VisibleForTesting
    void captureScreenshotThenLaunchPromptOptions() {
        InitialScreenshotHelper.captureScreenshot((InitialScreenshotHelper.InitialScreenshotCapturingListener)new InitialScreenshotHelper.InitialScreenshotCapturingListener(){

            public void onScreenshotCapturedSuccessfully(Uri uri) {
                InvocationRequestListenerImp.this.launchPromptOptionActivity(uri);
            }

            public void onScreenshotCapturingFailed(Throwable throwable) {
                InvocationRequestListenerImp.this.launchPromptOptionActivity(null);
            }
        });
    }

    @SuppressLint(value={"SwitchIntDef"})
    @VisibleForTesting
    void invokeWithMode(int n) {
        InstabugSDKLogger.d((String)"IBG-Core", (String)("[InvocationRequestListenerImp#invokeWithMode] Invoking with mode: " + n));
        if (InstabugCore.getRunningSession() == null) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"invokeWithMode() called but session is not started yet!");
            return;
        }
        PluginPromptOption pluginPromptOption = null;
        switch (n) {
            default: {
                break;
            }
            case 4: {
                this.invokeWithoutScreenshot(2);
                break;
            }
            case 3: {
                pluginPromptOption = PromptOptionManager.getPluginByIdentifier((int)3, (boolean)false);
                break;
            }
            case 2: {
                pluginPromptOption = PromptOptionManager.getPluginByIdentifier((int)1, (boolean)false);
                break;
            }
            case 1: {
                pluginPromptOption = PromptOptionManager.getPluginByIdentifier((int)0, (boolean)false);
            }
        }
        if (pluginPromptOption == null) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationRequestListenerImp#invokeWithMode] PluginPromptOption is null");
            return;
        }
        InvocationRequestListenerImp invocationRequestListenerImp = this;
        InstabugSDKLogger.d((String)"IBG-Core", (String)("[InvocationRequestListenerImp#invokeWithMode] Proceeding with PluginPromptOption: " + pluginPromptOption.getPromptOptionIdentifier()));
        InstabugSDKLogger.d((String)"IBG-Core", (String)("[InvocationRequestListenerImp#invokeWithMode] isInitialScreenshotRequired: " + invocationRequestListenerImp.isInitialScreenshotIsRequired()));
        if (invocationRequestListenerImp.isInitialScreenshotIsRequired()) {
            this.captureScreenshotThenInvoke(pluginPromptOption);
        } else {
            this.invoke(null, pluginPromptOption);
        }
    }

    @VisibleForTesting
    void captureScreenshotThenInvoke(final PluginPromptOption pluginPromptOption) {
        InitialScreenshotHelper.captureScreenshot((InitialScreenshotHelper.InitialScreenshotCapturingListener)new InitialScreenshotHelper.InitialScreenshotCapturingListener(){

            public void onScreenshotCapturedSuccessfully(Uri uri) {
                InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationRequestListenerImp#capturingScreenshotThenInvoke] Screenshot captured successfully.");
                InvocationRequestListenerImp.this.invoke(uri, pluginPromptOption);
            }

            public void onScreenshotCapturingFailed(Throwable throwable) {
                InstabugSDKLogger.d((String)"IBG-Core", (String)("[InvocationRequestListenerImp#capturingScreenshotThenInvoke] Screenshot capturing failed with throwable." + throwable.getMessage()));
                InvocationRequestListenerImp.this.invoke(null, pluginPromptOption);
            }
        });
    }

    @VisibleForTesting
    void launchPromptOptionActivity(@Nullable Uri uri) {
        InvocationRequestListenerImp invocationRequestListenerImp = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (invocationRequestListenerImp != null) {
            PromptOptionsLauncher.getInstance().launchPromptOptionsActivity((Activity)invocationRequestListenerImp, uri);
        }
    }
}

