/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import com.instabug.bug.BugReportingWrapper;
import com.instabug.bug.OnSdkDismissedCallback$DismissType;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.reportingpromptitems.AskQuestionPromptItem;
import com.instabug.bug.reportingpromptitems.BugReportingPromptItem;
import com.instabug.bug.reportingpromptitems.FeedbackPromptItem;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import java.util.ArrayList;

public abstract class ReportingPluginWrapper {
    public static void init(Context context) {
        BugSettings.init(context);
        ReportingPluginWrapper.checkEncryptorVersion();
    }

    static ArrayList<PluginPromptOption> getPromptOptions(Context context) {
        ArrayList<PluginPromptOption> arrayList;
        ArrayList<PluginPromptOption> arrayList2 = arrayList;
        arrayList = new ArrayList<PluginPromptOption>();
        if (InstabugCore.isFeatureEnabled((String)"BUG_REPORTING")) {
            if (ReportingPluginWrapper.isReportTypeEnabled("bug")) {
                arrayList2.add(new BugReportingPromptItem().getItemOption(context));
            }
            if (ReportingPluginWrapper.isReportTypeEnabled("feedback")) {
                arrayList2.add(new FeedbackPromptItem().getItemOption(context));
            }
            if (ReportingPluginWrapper.isReportTypeEnabled("ask a question")) {
                ReportingPluginWrapper.addAskQuestionOption(arrayList2, context);
            }
        }
        return arrayList2;
    }

    private static void addAskQuestionOption(ArrayList<PluginPromptOption> arrayList, Context context) {
        if (!ReportingPluginWrapper.isMessagingEnabled()) {
            return;
        }
        if (ReportingPluginWrapper.isAskQuestionEnabled()) {
            arrayList.add(new AskQuestionPromptItem().getItemOption(context));
        }
    }

    private static boolean isReportTypeEnabled(String string2) {
        return BugSettings.getInstance().getReportTypeStatus(string2);
    }

    static ArrayList<PluginPromptOption> getReportingOptions(boolean bl, Context context) {
        ArrayList<PluginPromptOption> arrayList;
        ArrayList<PluginPromptOption> arrayList2 = arrayList;
        arrayList = new ArrayList<PluginPromptOption>();
        if (!bl && InstabugCore.isFeatureEnabled((String)"BUG_REPORTING")) {
            ArrayList<PluginPromptOption> arrayList3 = arrayList2;
            arrayList3.add(new BugReportingPromptItem().getItemOption(context));
            arrayList3.add(new FeedbackPromptItem().getItemOption(context));
            arrayList3.add(new AskQuestionPromptItem().getItemOption(context));
        } else if (bl) {
            ArrayList<PluginPromptOption> arrayList4 = arrayList2;
            arrayList4.add(new BugReportingPromptItem().getItemOption(context));
            arrayList4.add(new FeedbackPromptItem().getItemOption(context));
            arrayList4.add(new AskQuestionPromptItem().getItemOption(context));
        }
        return arrayList2;
    }

    private static boolean isMessagingEnabled() {
        return InstabugCore.getFeatureState((String)"IN_APP_MESSAGING") == Feature.State.ENABLED;
    }

    private static boolean isAskQuestionEnabled() {
        return BugSettings.getInstance().getReportTypeStatus("ask a question");
    }

    public static void release() {
    }

    public static OnSdkDismissCallback.DismissType getDismissType(OnSdkDismissedCallback$DismissType onSdkDismissedCallback$DismissType) {
        int n = 1.$SwitchMap$com$instabug$bug$OnSdkDismissedCallback$DismissType[onSdkDismissedCallback$DismissType.ordinal()];
        if (n != 2) {
            if (n != 3) {
                return OnSdkDismissCallback.DismissType.CANCEL;
            }
            return OnSdkDismissCallback.DismissType.ADD_ATTACHMENT;
        }
        return OnSdkDismissCallback.DismissType.SUBMIT;
    }

    public static OnSdkDismissCallback.ReportType getReportType(String string2) {
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1621082316: {
                if (!string2.equals("ask a question")) break;
                n = 3;
                break;
            }
            case 253684815: {
                if (!string2.equals("not-available")) break;
                n = 5;
                break;
            }
            case 97908: {
                if (!string2.equals("bug")) break;
                n = 1;
                break;
            }
            case -191501435: {
                if (!string2.equals("feedback")) break;
                n = 2;
                break;
            }
            case -1562738717: {
                if (!string2.equals("Frustrating experience")) break;
                n = 4;
            }
        }
        switch (n) {
            default: {
                return OnSdkDismissCallback.ReportType.BUG;
            }
            case 5: {
                return OnSdkDismissCallback.ReportType.OTHER;
            }
            case 4: {
                return OnSdkDismissCallback.ReportType.FRUSTRATING_EXPERIENCE;
            }
            case 3: {
                return OnSdkDismissCallback.ReportType.QUESTION;
            }
            case 2: 
        }
        return OnSdkDismissCallback.ReportType.FEEDBACK;
    }

    public static void initDefaultPromptOptionAvailabilityState() {
        BugReportingWrapper.setReportTypes(0, 1, 2);
    }

    private static void checkEncryptorVersion() {
        if (BugSettings.getInstance().isFirstRunAfterEncryptorUpdate()) {
            ReportingPluginWrapper.dropBugsDatabaseTable();
        }
    }

    private static void dropBugsDatabaseTable() {
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(() -> {
            ServiceLocator.getBugReportsDbHelper().deleteAll();
            BugSettings.getInstance().setFirstRunAfterEncryptorUpdate(false);
        }).orchestrate();
    }
}

