package com.instabug.chat.model;

import android.annotation.SuppressLint;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * @author Hossam
 */

@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class MessageAction implements Cacheable {

    // keys used by toJson() & fromJson() methods
    public static final String KEY_TYPE = "type";
    public static final String KEY_TITLE = "title";
    public static final String KEY_URL = "url";

    private Type type;
    private String title;
    private String url;

    public static ArrayList<MessageAction> fromJson(JSONArray messageActionsJsonArray) throws
            JSONException {
        ArrayList<MessageAction> messageActions = new ArrayList<>();
        for (int i = 0; i < messageActionsJsonArray.length(); i++) {
            MessageAction messageAction = new MessageAction();
            messageAction.fromJson(messageActionsJsonArray.getString(i));
            messageActions.add(messageAction);
        }
        return messageActions;
    }

    public static JSONArray toJson(ArrayList<MessageAction> messageActions) throws JSONException {
        JSONArray messageActionsActions = new JSONArray();
        for (int i = 0; i < messageActions.size(); i++) {
            messageActionsActions.put(messageActions.get(i).toJson());
        }
        return messageActionsActions;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * fromJson converts MessageAction in JSONObject format into MessageAction model
     *
     * @param messageActionAsJson MessageAction in JSONObject format
     * @return MessageAction model
     * @throws JSONException
     */
    @Override
    public void fromJson(String messageActionAsJson) throws JSONException {
        JSONObject actionJsonObject = new JSONObject(messageActionAsJson);
        if (actionJsonObject.has(KEY_URL))
            setUrl(actionJsonObject.getString(KEY_URL));
        if (actionJsonObject.has(KEY_TITLE))
            setTitle(actionJsonObject.getString(KEY_TITLE));
        if (actionJsonObject.has(KEY_TYPE))
            switch (actionJsonObject.getString(KEY_TYPE)) {
                case "button":
                    setType(MessageAction.Type.BUTTON);
                    break;
                default:
                    setType(Type.NOT_AVAILABLE);
                    break;
            }
    }

    /**
     * toJson converts data model into Json object
     *
     * @return MessageAction as JSONObject
     * @throws JSONException
     */
    @Override
    public String toJson() throws JSONException {
        JSONObject actionJsonObject = new JSONObject();
        actionJsonObject.put(KEY_TYPE, this.type.toString());
        actionJsonObject.put(KEY_TITLE, this.title);
        actionJsonObject.put(KEY_URL, this.url);

        return actionJsonObject.toString();
    }

    @Override
    public String toString() {
        return "Type: " + getType() + ", title: " + getTitle() + ", url: " + getUrl();
    }

    @Override
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION")
    public boolean equals(Object messageAction) {
        if (messageAction != null && messageAction instanceof MessageAction) {
            MessageAction comparedMessageAction = (MessageAction) messageAction;
            return String.valueOf(comparedMessageAction.getTitle()).equals(String.valueOf
                    (getTitle()))
                    && String.valueOf(comparedMessageAction.getUrl()).equals(String.valueOf
                    (getUrl()))
                    && comparedMessageAction.getType() == getType();
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (getTitle() != null && getUrl() != null && getType() != null) {
            String stringHashCode = String.valueOf(getTitle().hashCode()) +
                    String.valueOf(getUrl().hashCode()) +
                    String.valueOf(getType().toString().hashCode());
            return stringHashCode.hashCode();
        } else
            return -1;
    }

    public enum Type {
        BUTTON("button"), NOT_AVAILABLE("not-available");
        private final String name;

        Type(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return name;
        }
    }
}
