/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.bug.internal.video.InternalScreenRecordHelper;
import com.instabug.bug.internal.video.customencoding.AudioEncodeConfig;
import com.instabug.bug.internal.video.customencoding.ScreenRecorder;
import com.instabug.bug.internal.video.customencoding.VideoEncodeConfig;
import com.instabug.library.Feature;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.video.InstabugVideoUtils;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.MicUtils;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.IOException;

@TargetApi(value=21)
final class ScreenRecordingSession {
    private final Context context;
    private final Listener listener;
    private final Feature.State isAUSAudioCapturingEnabled;
    private final String outputFile;
    private boolean running;
    private final boolean isManuallyRecording;
    @Nullable
    private MediaProjection projection;
    @Nullable
    private ScreenRecorder mRecorder;

    @RequiresApi(api=21)
    ScreenRecordingSession(Context object, Listener listener, ScreenRecorder.Callback callback, int n, Intent object2) {
        Object object3;
        this.context = object;
        this.listener = listener;
        boolean bl = InternalScreenRecordHelper.getInstance().isRecording();
        ScreenRecordingSession screenRecordingSession = this;
        screenRecordingSession.isManuallyRecording = bl;
        screenRecordingSession.isAUSAudioCapturingEnabled = object3 = SettingsManager.getInstance().getAutoScreenRecordingAudioCapturingState();
        this.outputFile = bl ? AttachmentsUtility.getVideoFile((Context)object).getAbsolutePath() : AttachmentManager.getAutoScreenRecordingFile((Context)object).getAbsolutePath();
        object = (MediaProjectionManager)object.getSystemService("media_projection");
        if (object != null) {
            this.projection = object.getMediaProjection(n, object2);
        }
        object = this.createVideoConfig();
        if (!bl && object3 != Feature.State.ENABLED) {
            ScreenRecorder screenRecorder;
            ScreenRecorder screenRecorder2 = screenRecorder;
            ScreenRecordingSession screenRecordingSession2 = this;
            MediaProjection mediaProjection = screenRecordingSession2.projection;
            object2 = screenRecordingSession2.outputFile;
            screenRecorder = new ScreenRecorder((VideoEncodeConfig)object, null, mediaProjection, (String)object2);
            this.mRecorder = screenRecorder2;
        } else {
            ScreenRecorder screenRecorder;
            AudioEncodeConfig audioEncodeConfig = this.createAudioConfig();
            ScreenRecorder screenRecorder3 = screenRecorder;
            ScreenRecordingSession screenRecordingSession3 = this;
            object2 = screenRecordingSession3.projection;
            object3 = screenRecordingSession3.outputFile;
            screenRecorder = new ScreenRecorder((VideoEncodeConfig)object, audioEncodeConfig, (MediaProjection)object2, (String)object3);
            this.mRecorder = screenRecorder3;
        }
        this.startRecording(callback);
    }

    @Nullable
    private AudioEncodeConfig createAudioConfig() {
        if (!MicUtils.isAudioPermissionGranted()) {
            return null;
        }
        return new AudioEncodeConfig();
    }

    private VideoEncodeConfig createVideoConfig() {
        int[] nArray = this.getSelectedWithHeight();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        return new VideoEncodeConfig(n, n2, n3);
    }

    private int[] getSelectedWithHeight() {
        DisplayMetrics displayMetrics = DeviceStateProvider.getDisplayMetrics((Context)this.context);
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        int n3 = displayMetrics.densityDpi;
        return new int[]{n, n2, n3};
    }

    private void startRecording(ScreenRecorder.Callback callback) {
        ScreenRecorder screenRecorder = this.mRecorder;
        if (screenRecorder != null) {
            screenRecorder.setCallback(callback);
            this.mRecorder.start();
        }
        ScreenRecordingSession screenRecordingSession = this;
        screenRecordingSession.setRunning(true);
        screenRecordingSession.listener.onStart();
        if (screenRecordingSession.isManuallyRecording) {
            InternalScreenRecordHelper.getInstance().startTimerOnRecordingFAB();
        }
        if (this.isAUSAudioCapturingEnabled == Feature.State.DISABLED) {
            MicUtils.muteMic((Context)this.context);
        } else {
            MicUtils.unmuteMic((Context)this.context);
        }
        InstabugSDKLogger.d((String)"IBG-Core", (String)"Screen recording started");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopRecording(ScreenRecorder.Callback var1_3) {
        block17: {
            block18: {
                block16: {
                    if (!this.running) {
                        return;
                    }
                    v0 = this;
                    v0.setRunning(false);
                    try {
                        var2_5 = v0.projection;
                        if (var2_5 == null) break block16;
                    }
                    catch (Throwable var1_4) {
                        break block17;
                    }
                    catch (RuntimeException v1) {
                        ** GOTO lbl-1000
                    }
                    var2_5.stop();
                }
                if ((var2_5 = this.mRecorder) == null) ** GOTO lbl17
                {
                    var2_5.setCallback((ScreenRecorder.Callback)var1_3);
lbl17:
                    // 2 sources

                    if ((var1_3 = this.mRecorder) == null) ** GOTO lbl19
                }
                {
                    var1_3.quit();
lbl19:
                    // 2 sources

                    v2 = this;
                    this.mRecorder = null;
                }
                try {
                    v2.listener.onStop();
                    return;
                }
                catch (RuntimeException var0_1) {
                    InstabugSDKLogger.e((String)"IBG-Core", (String)("RuntimeException happened " + var0_1.getMessage()));
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    if (v1.getMessage() != null) {
                        InstabugSDKLogger.e((String)"IBG-Core", (String)"Error while stopping screen recording");
                    }
                    if ((var1_3 = this.mRecorder) == null) break block18;
                }
                {
                    var1_3.quit();
                }
            }
            try {
                this.listener.onStop();
                return;
            }
            catch (RuntimeException var0_2) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)("RuntimeException happened " + var0_2.getMessage()));
            }
            return;
        }
        try {
            this.listener.onStop();
            throw var1_4;
        }
        catch (RuntimeException v3) {}
        throw var1_4;
    }

    synchronized void destroy(ScreenRecorder.Callback callback) {
        if (this.running) {
            this.stopRecording(callback);
        } else {
            ScreenRecordingSession screenRecordingSession = this;
            screenRecordingSession.listener.onError();
            screenRecordingSession.listener.onEnd();
        }
    }

    void deleteVideoFile() {
        ScreenRecordingSession screenRecordingSession = this;
        PoolProvider.postIOTask(() -> {
            File file;
            File file2 = file;
            if (!new File(screenRecordingSession.outputFile).exists()) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)"Screen recording file doesn't exist - couldn't be deleted");
                return;
            }
            if (!file2.delete()) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)"Screen recording file couldn't be deleted");
            }
            this.listener.onEnd();
        });
    }

    public synchronized void hold() {
        File file;
        File file2 = file;
        file = new File(this.outputFile);
        InstabugSDKLogger.v((String)"IBG-Core", (String)("Recorded video file size: " + file2.length() / 1024L + " KB"));
        if (this.isManuallyRecording) {
            InternalScreenRecordHelper.getInstance().setAutoScreenRecordingFile(file2);
            InternalScreenRecordHelper.getInstance().onRecordingFinished();
        } else {
            InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file2);
        }
        this.listener.onEnd();
    }

    synchronized void trim(int n) {
        PoolProvider.postIOTask(() -> {
            block4: {
                Exception exception2;
                File file;
                File file2 = file;
                file2(this.outputFile);
                try {
                    try {
                        File file3 = InstabugVideoUtils.startTrim((File)file, (File)AttachmentManager.getAutoScreenRecordingFile((Context)this.context), (int)n);
                        InstabugSDKLogger.v((String)"IBG-Core", (String)("Recorded video file size after trim: " + file3.length() / 1024L + " KB"));
                        InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file3);
                        break block4;
                    }
                    catch (IllegalArgumentException exception2) {
                    }
                }
                catch (IOException exception2) {
                    // empty catch block
                }
                exception2.printStackTrace();
                InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file2);
            }
            this.listener.onEnd();
        });
    }

    public synchronized void setRunning(boolean bl) {
        this.running = bl;
    }

    static interface Listener {
        public void onStart();

        public void onStop();

        public void onError();

        public void onEnd();
    }
}

