/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chat;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.projection.MediaProjectionConfig;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.instabug.bug.R;
import com.instabug.bug.internal.video.VideoPlayerFragment;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.FlatMessage;
import com.instabug.chat.model.Message;
import com.instabug.chat.screenrecording.ExternalScreenRecordHelper;
import com.instabug.chat.ui.annotation.ChatAnnotationFragment;
import com.instabug.chat.ui.base.ToolbarFragment;
import com.instabug.chat.ui.chat.AttachmentsBottomSheetFragment;
import com.instabug.chat.ui.chat.ChatContract$Presenter;
import com.instabug.chat.ui.chat.ChatContract$View;
import com.instabug.chat.ui.chat.ChatPresenter;
import com.instabug.chat.ui.chat.ImageAttachmentViewerFragment;
import com.instabug.chat.ui.chat.MessagesListAdapter;
import com.instabug.common.photopicker.PhotoPickerActivity;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.internal.video.RequestPermissionActivityLauncher;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.SystemServiceUtils;
import com.instabug.library.util.ThemeApplier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED", "ERADICATE_FIELD_NOT_NULLABLE"})
public class ChatFragment
extends ToolbarFragment<ChatContract$Presenter>
implements ChatContract$View,
View.OnClickListener,
MessagesListAdapter.OnMessageItemClickListener,
AttachmentsBottomSheetFragment.Callbacks,
ChatAnnotationFragment.Callbacks {
    private String chatNumber;
    private MessagesListAdapter messagesListAdapter;
    private EditText messageEditText;
    private String chatTitle;
    @Nullable
    ImageButton backToConversationsToolbarLeftButton;
    @Nullable
    ImageView attachImageView;

    public static ChatFragment newInstance(String string2) {
        Bundle bundle;
        ChatFragment chatFragment = new ChatFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("chat_number", string2);
        chatFragment.setArguments(bundle2);
        return chatFragment;
    }

    public static ChatFragment newInstance(String string2, Attachment attachment) {
        Bundle bundle;
        ChatFragment chatFragment = new ChatFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("chat_number", string2);
        bundle2.putSerializable("attachment", (Serializable)attachment);
        chatFragment.setArguments(bundle2);
        return chatFragment;
    }

    private void requestAudioPermission() {
        if (stringArray3.getActivity() != null) {
            if (ContextCompat.checkSelfPermission((Context)stringArray3.getActivity(), (String)"android.permission.RECORD_AUDIO") != 0) {
                String[] stringArray = stringArray3;
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                stringArray2[0] = "android.permission.RECORD_AUDIO";
                stringArray.requestPermissions(stringArray3, 163);
            } else {
                stringArray3.requestVideoPermissions();
            }
        }
    }

    private void requestVideoPermissions() {
        int n;
        if (chatFragment2.getActivity() != null && (n = Build.VERSION.SDK_INT) >= 21) {
            MediaProjectionManager mediaProjectionManager;
            if (InstabugMediaProjectionIntent.isMediaProjectionIntentReadyToUse()) {
                ChatFragment chatFragment = chatFragment2;
                ChatFragment chatFragment2 = InstabugMediaProjectionIntent.getMediaProjectionIntent();
                BaseContract.Presenter presenter = chatFragment.presenter;
                if (presenter != null && chatFragment2 != null) {
                    ((ChatContract$Presenter)presenter).openVideoRecorder((Intent)chatFragment2);
                }
            } else if (InstabugMediaProjectionIntent.canStartMediaProjectionFGService((Context)chatFragment2.getActivity()) && (mediaProjectionManager = (MediaProjectionManager)chatFragment2.getActivity().getSystemService("media_projection")) != null) {
                Intent intent = n >= 34 ? mediaProjectionManager.createScreenCaptureIntent(MediaProjectionConfig.createConfigForDefaultDisplay()) : mediaProjectionManager.createScreenCaptureIntent();
                chatFragment2.startActivityForResult(intent, 3890);
            }
        }
    }

    private void openAttachmentBottomSheetFragment() {
        if (this.getActivity() != null && this.presenter != null) {
            int n = R.id.instabug_fragment_container;
            this.getActivity().getSupportFragmentManager().beginTransaction().add(n, (Fragment)AttachmentsBottomSheetFragment.newInstance(this), "attachments_bottom_sheet_fragment").addToBackStack("attachments_bottom_sheet_fragment").commit();
        }
    }

    private void pickPhotoFromGallery() {
        ChatFragment chatFragment = chatFragment.presenter;
        if (chatFragment != null) {
            ((ChatContract$Presenter)((Object)chatFragment)).startImageFromGalleryPicker();
        }
    }

    private Intent getPhotoPickerIntent(@NonNull Context context) {
        return new Intent(context, PhotoPickerActivity.class);
    }

    public void onCreate(@Nullable Bundle object) {
        ChatPresenter chatPresenter;
        ChatFragment chatFragment = this;
        super.onCreate(object);
        chatFragment.setRetainInstance(true);
        if (chatFragment.getArguments() != null) {
            this.chatNumber = this.getArguments().getString("chat_number");
        }
        object = chatPresenter;
        chatPresenter = new ChatPresenter(this);
        this.presenter = object;
    }

    public void onViewCreated(@NotNull View object, @Nullable Bundle bundle) {
        AccessibilityDelegateCompat accessibilityDelegateCompat;
        ChatFragment chatFragment = this;
        super.onViewCreated(object, bundle);
        bundle = chatFragment.presenter;
        if (bundle != null) {
            ((ChatContract$Presenter)bundle).init(this.chatNumber);
        }
        View view = object;
        object = accessibilityDelegateCompat;
        accessibilityDelegateCompat = new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View object, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                1 v0 = this;
                super.onInitializeAccessibilityNodeInfo(object, accessibilityNodeInfoCompat);
                if (v0.ChatFragment.this.chatTitle != null) {
                    ChatFragment chatFragment = ChatFragment.this;
                    int n = R.string.ibg_chat_conversation_with_name_content_description;
                    object = chatFragment.chatTitle;
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = object;
                    accessibilityNodeInfoCompat.setContentDescription((CharSequence)chatFragment.getLocalizedString(n, objectArray2));
                } else {
                    accessibilityNodeInfoCompat.setContentDescription((CharSequence)ChatFragment.this.getLocalizedString(R.string.ibg_chat_conversation_content_description));
                }
            }
        };
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)object);
    }

    public void onStart() {
        BaseContract.Presenter presenter;
        ChatFragment chatFragment = this;
        super.onStart();
        Object object = chatFragment.presenter;
        if (object != null) {
            ((ChatContract$Presenter)object).listen();
        }
        object = null;
        if (this.getArguments() != null) {
            object = (Attachment)this.getArguments().getSerializable("attachment");
        }
        if (object != null && (presenter = this.presenter) != null) {
            ((ChatContract$Presenter)presenter).handleSentAttachment((Attachment)object);
        }
        if (this.getArguments() != null) {
            this.getArguments().clear();
        }
    }

    public void onStop() {
        ChatFragment chatFragment = chatFragment2;
        super.onStop();
        ChatFragment chatFragment2 = chatFragment.presenter;
        if (chatFragment2 != null) {
            ((ChatContract$Presenter)((Object)chatFragment2)).sleep();
        }
    }

    public void onDestroyView() {
        ChatFragment chatFragment = this;
        super.onDestroyView();
        BaseContract.Presenter presenter = chatFragment.presenter;
        if (presenter != null) {
            ((ChatContract$Presenter)presenter).cleanOfflineChats();
        }
        ChatFragment chatFragment2 = this;
        chatFragment2.messageEditText = null;
        chatFragment2.attachImageView = null;
        chatFragment2.backToConversationsToolbarLeftButton = null;
    }

    @Override
    protected int getContentLayout() {
        return R.layout.instabug_fragment_chat;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void initContentViews(View view, @Nullable Bundle bundle) {
        ArrayList arrayList;
        MessagesListAdapter messagesListAdapter;
        Object object;
        Object object2;
        bundle = (ImageButton)view.findViewById(R.id.instabug_btn_toolbar_right);
        if (bundle != null) {
            bundle.setVisibility(8);
        }
        View view2 = view;
        bundle = (ListView)view2.findViewById(R.id.instabug_lst_messages);
        this.messageEditText = object2 = (EditText)view2.findViewById(R.id.instabug_edit_text_new_message);
        if (object2 != null) {
            ChatFragment chatFragment = this;
            object2.setHint((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.CONVERSATION_TEXT_FIELD_HINT, (String)this.getLocalizedString(R.string.instabug_str_sending_message_hint)));
            chatFragment.messageEditText.setInputType(16385);
            ThemeApplier.applyEditTextStyle((EditText)chatFragment.messageEditText, (IBGTheme)this.getIBGTheme());
        }
        object2 = (ImageView)view.findViewById(R.id.instabug_btn_send);
        if (this.getContext() != null) {
            object = Colorizer.getPrimaryColorTintedDrawable((Drawable)ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ibg_chat_ic_send));
            if (object2 != null) {
                object2.setImageDrawable(object);
                object2.setContentDescription((CharSequence)this.getLocalizedString(R.string.ibg_chat_send_message_btn_content_description));
            }
        }
        if (object2 != null) {
            object2.setOnClickListener((View.OnClickListener)this);
        }
        object2 = messagesListAdapter;
        ChatFragment chatFragment = this;
        object = arrayList;
        arrayList = new ArrayList();
        FragmentActivity fragmentActivity = chatFragment.getActivity();
        IBGTheme iBGTheme = chatFragment.getIBGTheme();
        messagesListAdapter = new MessagesListAdapter((List<FlatMessage>)object, (Context)fragmentActivity, (ListView)bundle, this, iBGTheme);
        this.messagesListAdapter = object2;
        if (bundle != null) {
            bundle.setAdapter((ListAdapter)object2);
        }
        bundle = (ImageButton)view.findViewById(R.id.instabug_btn_toolbar_left);
        this.backToConversationsToolbarLeftButton = bundle;
        if (bundle != null) {
            bundle.setTag(R.id.TAG_BTN_BACK, (Object)"instabug_btn_back");
            this.backToConversationsToolbarLeftButton.setContentDescription((CharSequence)this.getLocalizedString(R.string.ibg_chat_back_to_conversations_btn_content_description));
        }
        view = (ImageView)view.findViewById(R.id.instabug_btn_attach);
        this.attachImageView = view;
        if (view != null) {
            view.setContentDescription((CharSequence)this.getLocalizedString(R.string.ibg_chat_add_attachment_btn_content_description));
        }
    }

    @Override
    protected String getTitle() {
        Chat chat = ChatsCacheManager.getChat(this.chatNumber);
        if (chat != null) {
            this.chatTitle = chat.getTitle();
            return this.chatTitle;
        }
        return this.getLocalizedString(R.string.instabug_str_empty);
    }

    @Override
    protected void onDoneButtonClicked() {
    }

    public void onClick(View object) {
        if (object.getId() == R.id.instabug_btn_send) {
            object = this.messageEditText.getText().toString();
            if (TextUtils.isEmpty((CharSequence)object.trim())) {
                return;
            }
            BaseContract.Presenter presenter = this.presenter;
            if (presenter != null) {
                ((ChatContract$Presenter)presenter).sendMessage(((ChatContract$Presenter)presenter).createMessage(((ChatContract$Presenter)presenter).getChat().getId(), (String)object));
            }
            this.messageEditText.setText((CharSequence)"");
        } else if (object.getId() == R.id.instabug_btn_attach && this.getActivity() != null) {
            ChatFragment chatFragment = this;
            SystemServiceUtils.hideInputMethod((Activity)chatFragment.getActivity());
            chatFragment.openAttachmentBottomSheetFragment();
        }
    }

    @Override
    public void onVideoAttachmentClicked(String string2) {
        if (this.getActivity() != null) {
            ChatFragment chatFragment = this;
            SystemServiceUtils.hideInputMethod((Activity)chatFragment.getActivity());
            int n = R.id.instabug_fragment_container;
            chatFragment.getActivity().getSupportFragmentManager().beginTransaction().add(n, (Fragment)VideoPlayerFragment.newInstance(string2), "VideoPlayerFragment").addToBackStack("VideoPlayerFragment").commit();
        }
    }

    @Override
    public void onImageAttachmentClicked(String string2) {
        if (this.getActivity() != null) {
            ChatFragment chatFragment = this;
            SystemServiceUtils.hideInputMethod((Activity)chatFragment.getActivity());
            int n = R.id.instabug_fragment_container;
            chatFragment.getActivity().getSupportFragmentManager().beginTransaction().add(n, (Fragment)ImageAttachmentViewerFragment.newInstance(string2), "image_attachment_viewer_fragment").addToBackStack("image_attachment_viewer_fragment").commit();
        }
    }

    @Override
    public void onMessageActionClicked(String string2) {
        ChatFragment chatFragment = this;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        try {
            chatFragment.startActivity(intent);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)("Unable to view this url " + string2 + "\nError message: " + exception.getMessage()));
        }
    }

    @Override
    public void attachScreenshot() {
        ChatFragment chatFragment = chatFragment.presenter;
        if (chatFragment != null) {
            ((ChatContract$Presenter)((Object)chatFragment)).attachScreenshot();
        }
    }

    @Override
    public void attachImageFromGallery() {
        this.pickPhotoFromGallery();
    }

    @Override
    public void attachVideo() {
        this.recordScreen();
    }

    public void recordScreen() {
        if (!ExternalScreenRecordHelper.getInstance().isRecording()) {
            this.requestAudioPermission();
        } else if ((this = this.getContext()) != null) {
            Toast.makeText((Context)this, (int)R.string.instabug_str_video_encoder_busy, (int)0).show();
        }
    }

    @Override
    public void onImageEditingDone(String string2, Uri uri, String string3) {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null && string2 != null && string2.equals(((ChatContract$Presenter)presenter).getChat().getId())) {
            string2 = this.presenter;
            ((ChatContract$Presenter)((Object)string2)).sendMessage(((ChatContract$Presenter)((Object)string2)).createAttachmentMessage(((ChatContract$Presenter)((Object)string2)).getChat().getId(), ((ChatContract$Presenter)this.presenter).createImageAttachment(uri, string3)));
        }
    }

    @Override
    public void onImageEditingCancelled(String string2, Uri uri) {
        if ((this = this.getActivity()) != null) {
            this.onBackPressed();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        ChatFragment chatFragment = chatFragment2;
        super.onActivityResult(n, n2, intent);
        ChatFragment chatFragment2 = chatFragment.presenter;
        if (chatFragment2 != null) {
            ((ChatContract$Presenter)((Object)chatFragment2)).onActivityResult(n, n2, intent);
        }
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        if (nArray.length > 0 && nArray[0] == 0) {
            if (n == 163) {
                this.requestVideoPermissions();
            } else {
                super.onRequestPermissionsResult(n, stringArray, nArray);
            }
        } else if (n == 163) {
            this.requestVideoPermissions();
        }
    }

    @Override
    public void makeLeftTopButtonCloseButton() {
        ChatFragment chatFragment = chatFragment.backToConversationsToolbarLeftButton;
        if (chatFragment != null) {
            chatFragment.setImageResource(R.drawable.ibg_core_ic_close);
        }
    }

    @Override
    public void makeLeftTopButtonBackButton() {
        ImageButton imageButton = this.backToConversationsToolbarLeftButton;
        if (imageButton != null) {
            imageButton.setImageResource(R.drawable.ibg_core_ic_back);
            this.backToConversationsToolbarLeftButton.setRotation((float)this.getResources().getInteger(R.integer.instabug_icon_lang_rotation));
        }
    }

    @Override
    public void showAttachmentButton() {
        ImageView imageView;
        if (this.rootView != null && (imageView = this.attachImageView) != null) {
            Colorizer.applyPrimaryColorTint((ImageView)imageView);
            this.attachImageView.setOnClickListener((View.OnClickListener)this);
        }
    }

    @Override
    public void hideAttachmentButton() {
        ChatFragment chatFragment = chatFragment.attachImageView;
        if (chatFragment != null) {
            chatFragment.setVisibility(8);
        }
    }

    @Override
    public void updateChatMessages(List<Message> list) {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null) {
            this.messagesListAdapter.setFlatMessageItems(((ChatContract$Presenter)presenter).flattenMessages(list));
        }
    }

    @Override
    public void notifyUIForUpdates() {
        this.messagesListAdapter.notifyDataSetChanged();
    }

    @Override
    public void annotateAttachmentImage(Uri uri, String string2) {
        ChatFragment chatFragment = this;
        ChatContract$Presenter chatContract$Presenter = (ChatContract$Presenter)chatFragment.presenter;
        if (chatFragment.getActivity() != null && chatContract$Presenter != null) {
            this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.instabug_fragment_container, (Fragment)ChatAnnotationFragment.newInstance(chatContract$Presenter.getChat().getTitle(), chatContract$Presenter.getChat().getId(), uri, string2), "annotation_fragment_for_chat").addToBackStack("annotation_fragment_for_chat").commit();
        }
        this.presenter = chatContract$Presenter;
    }

    @Override
    public void pickImageFromGallery() {
        Context context = this.getContext();
        if (context != null) {
            ChatFragment chatFragment = this;
            chatFragment.startActivityForResult(chatFragment.getPhotoPickerIntent(context), 161);
        }
    }

    @Override
    public void showMediaFileSizeAlert() {
        if (this.getActivity() != null) {
            Long l = 50L;
            new InstabugAlertDialog.Builder((Activity)this.getActivity()).setTitle(this.getLocalizedString(R.string.instabug_str_bugreport_file_size_limit_warning_title)).setMessage(this.getLocalizedString(R.string.instabug_str_bugreport_file_size_limit_warning_message, new Object[]{l})).setPositiveButton(this.getLocalizedString(R.string.instabug_str_ok), (dialogInterface, n) -> dialogInterface.dismiss()).show();
        }
    }

    @Override
    public void showVideoLengthAlert() {
        if (this.getActivity() != null) {
            new InstabugAlertDialog.Builder((Activity)this.getActivity()).setTitle(this.getLocalizedString(R.string.instabug_str_video_length_limit_warning_title)).setMessage(this.getLocalizedString(R.string.instabug_str_video_length_limit_warning_message)).setPositiveButton(this.getLocalizedString(R.string.instabug_str_ok), (dialogInterface, n) -> dialogInterface.dismiss()).show();
        }
    }

    @Override
    public void requestMediaProjectionPermission() {
        if (this.getActivity() != null) {
            RequestPermissionActivityLauncher.start((Activity)this.getActivity(), (boolean)false, (boolean)false, null);
        }
    }
}

