/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.synchronization;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.synchronization.OnNewMessagesReceivedListener;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class NewMessagesHandler {
    private static NewMessagesHandler INSTANCE;
    private List<OnNewMessagesReceivedListener> onNewMessagesReceivedListeners;

    public NewMessagesHandler() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.onNewMessagesReceivedListeners = arrayList2;
    }

    public static NewMessagesHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NewMessagesHandler();
        }
        return INSTANCE;
    }

    private void updateChatsCache(Context context, List<Message> object) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)("updating chats cache new messages count: " + object.size()));
        object = object.iterator();
        while (object.hasNext()) {
            Message message = (Message)object.next();
            if (this.isRemoteMessage(message)) {
                this.addRemoteMessage(message);
                continue;
            }
            if (!this.isLocalMessageAndReadyToBeSynced(message)) continue;
            InstabugSDKLogger.d((String)"IBG-BR", (String)("Message with id:" + message.getId() + " is ready to be synced"));
            try {
                ChatsCacheManager.updateLocalMessageWithSyncedMessage(context, message);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Failed to update local message with synced message, " + iOException.getMessage()), (Throwable)iOException);
            }
        }
    }

    private void invalidateThenUpdateChatsCache(Context context, List<Message> list) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)"START Invalidate Cache");
        List<Message> list2 = ChatsCacheManager.getNotSentMessages();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.invalidate();
        }
        NewMessagesHandler newMessagesHandler = this;
        InstabugSDKLogger.v((String)"IBG-BR", (String)"finish Invalidate Cache");
        newMessagesHandler.updateChatsCache(context, newMessagesHandler.combineMessages(list, list2));
    }

    private List<Message> combineMessages(List<Message> list, List<Message> arrayList) {
        ArrayList<Message> arrayList2;
        ArrayList<Message> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<Message>(list);
        for (Message message : arrayList3) {
            if (this.isLocalMessageChatStillExist(message, list)) {
                arrayList.add(message);
            }
            if (message.getMessageState() != Message.MessageState.SENT || this.getRemoteMessageThatEqualLocalMessage(message, list) == null) continue;
            arrayList.remove(this.getRemoteMessageThatEqualLocalMessage(message, list));
        }
        return arrayList;
    }

    private boolean isLocalMessageChatStillExist(Message message, List<Message> object) {
        Iterator<Message> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Message)iterator.next();
            if (message.getChatId() == null || !message.getChatId().equals(((Message)object).getChatId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Message getRemoteMessageThatEqualLocalMessage(Message message, List<Message> object) {
        Iterator<Message> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Message)iterator.next();
            if (!message.getId().equals(((Message)object).getId())) continue;
            return object;
        }
        return null;
    }

    private List<Message> getShouldBeNotifiedMessages(List<Message> object) {
        ArrayList<Message> arrayList;
        ArrayList<Message> arrayList2 = arrayList;
        arrayList = new ArrayList<Message>((Collection<Message>)object);
        object = object.iterator();
        while (object.hasNext()) {
            Message message = (Message)object.next();
            if (!this.isLocalMessageAndSynced(message) && !this.isLocalMessageAndReadyToBeSynced(message) && !this.isLocalMessageAndNotFullySent(message) && !message.isInbound() && !message.isRead()) continue;
            InstabugSDKLogger.d((String)"IBG-BR", (String)"Message removed from list to be notified");
            arrayList2.remove(message);
        }
        return arrayList2;
    }

    @Nullable
    private Chat getMessageChat(Message message) {
        if (message.getChatId() == null) {
            return null;
        }
        Object object = ChatsCacheManager.getCache();
        if (object != null && (object = (Chat)object.get((Object)message.getChatId())) != null) {
            return object;
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)"No local chats match messages's chat");
        return null;
    }

    @Nullable
    private List<Message> getMessageChatMessages(Message message) {
        if ((this = ((NewMessagesHandler)this).getMessageChat(message)) == null) {
            return null;
        }
        return ((Chat)this).getMessages();
    }

    @Nullable
    private Message isLocalMessage(Message message) {
        if ((iterator = ((NewMessagesHandler)((Object)iterator)).getMessageChatMessages(message)) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Message message2 = (Message)iterator.next();
                if (!message2.getId().equals(message.getId())) continue;
                return message2;
            }
        }
        return null;
    }

    private boolean isRemoteMessage(Message message) {
        return this.isLocalMessage(message) == null;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void addRemoteMessage(Message inMemoryCache) {
        if ((object = ((NewMessagesHandler)object).getMessageChat((Message)inMemoryCache)) == null && inMemoryCache.getChatId() != null) {
            Chat chat;
            InstabugSDKLogger.v((String)"IBG-BR", (String)("Chat with id " + inMemoryCache.getChatId() + " doesn't exist, creating new one"));
            Object object = chat;
            new Chat(inMemoryCache.getChatId()).setChatState(Chat.ChatState.SENT);
        }
        if (object != null) {
            ((Chat)object).getMessages().add((Message)inMemoryCache);
            InstabugSDKLogger.v((String)"IBG-BR", (String)("Message added to cached chat: " + object));
        }
        if ((inMemoryCache = ChatsCacheManager.getCache()) != null && object != null) {
            inMemoryCache.put((Object)((Chat)object).getId(), object);
        }
    }

    private boolean isLocalMessageAndSynced(Message message) {
        return (this = ((NewMessagesHandler)this).isLocalMessage(message)) != null && ((Message)this).getId().equals(message.getId()) && ((Object)((Object)((Message)this).getMessageState())).equals((Object)Message.MessageState.SYNCED) && ((Message)this).getAttachments().size() == message.getAttachments().size();
    }

    private boolean isLocalMessageAndReadyToBeSynced(Message message) {
        return (this = ((NewMessagesHandler)this).isLocalMessage(message)) != null && ((Message)this).getId().equals(message.getId()) && ((Object)((Object)((Message)this).getMessageState())).equals((Object)Message.MessageState.READY_TO_BE_SYNCED) && ((Message)this).getAttachments().size() == message.getAttachments().size();
    }

    private boolean isLocalMessageAndNotFullySent(Message message) {
        return (this = ((NewMessagesHandler)this).isLocalMessage(message)) != null && ((Message)this).getId().equals(message.getId()) && ((Object)((Object)((Message)this).getMessageState())).equals((Object)Message.MessageState.SENT) && ((Message)this).getAttachments().size() != message.getAttachments().size();
    }

    private void notifyAllListeners(List<Message> list) {
        if (ChatSettings.isNotificationEnable()) {
            for (int i = this.onNewMessagesReceivedListeners.size() - 1; i >= 0; --i) {
                Object object = this.onNewMessagesReceivedListeners.get(i);
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Notifying listener " + object));
                if (list != null && list.size() > 0) {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("Notifying listener with " + list.size() + " message(s)"));
                    list = object.onNewMessagesReceived(list);
                    object = "IBG-BR";
                    StringBuilder stringBuilder = new StringBuilder().append("Notified listener remained ");
                    Integer n = list != null ? Integer.valueOf(list.size()) : null;
                    InstabugSDKLogger.d((String)object, (String)stringBuilder.append(n).append(" message(s) to be sent to next listener").toString());
                    continue;
                }
                break;
            }
        } else {
            InstabugSDKLogger.v((String)"IBG-BR", (String)"Chat notification disabled");
        }
    }

    private void fireNewMessagesRunnable() {
        if (ChatSettings.getNewMessageRunnable() != null) {
            try {
                new Handler(Looper.getMainLooper()).post(ChatSettings.getNewMessageRunnable());
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"new message runnable failed to run.", (Throwable)exception);
            }
        }
    }

    public void handleNewMessagesReceived(Context context, boolean bl, JSONObject ... object) {
        NewMessagesHandler newMessagesHandler = this;
        List<Message> list = newMessagesHandler.parseNewMessages((JSONObject[])object);
        object = newMessagesHandler.getShouldBeNotifiedMessages(list);
        if (bl) {
            this.invalidateThenUpdateChatsCache(context, list);
        } else {
            this.updateChatsCache(context, list);
        }
        if (object.size() > 0) {
            this.fireNewMessagesRunnable();
        }
        if (this.onNewMessagesReceivedListeners.size() > 0) {
            this.notifyAllListeners((List<Message>)object);
            return;
        }
        throw new IllegalStateException("No one is listening for unread messages");
    }

    public void addOnNewMessagesReceivedListener(OnNewMessagesReceivedListener onNewMessagesReceivedListener) {
        if (!this.onNewMessagesReceivedListeners.contains(onNewMessagesReceivedListener)) {
            this.onNewMessagesReceivedListeners.add(onNewMessagesReceivedListener);
        }
    }

    public void removeOnNewMessagesReceivedListener(OnNewMessagesReceivedListener onNewMessagesReceivedListener) {
        this.onNewMessagesReceivedListeners.remove(onNewMessagesReceivedListener);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    public List<Message> parseNewMessages(JSONObject[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 10[TRYBLOCK] [10 : 200->207)] org.json.JSONException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

