/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.network.service;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.chat.network.util.MessagingServiceUtil;
import com.instabug.library.model.State;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.tokenmapping.TokenMappingServiceLocator;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagingService {
    private static MessagingService INSTANCE;
    private NetworkManager networkManager;

    private MessagingService() {
        NetworkManager networkManager;
        MessagingService messagingService = networkManager;
        networkManager = new NetworkManager();
        v1.networkManager = messagingService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MessagingService getInstance() {
        String string2 = MessagingService.class.getName();
        synchronized (string2) {
            Throwable throwable2;
            block4: {
                block3: {
                    try {
                        if (INSTANCE != null) break block3;
                        INSTANCE = new MessagingService();
                    }
                    catch (Throwable throwable2) {
                        break block4;
                    }
                }
                return INSTANCE;
            }
            throw throwable2;
        }
    }

    public void triggerChat(@Nullable State state, final Request.Callbacks<String, Throwable> callbacks) {
        if (state != null && callbacks != null) {
            Request.Callbacks<RequestResponse, Throwable> callbacks2;
            Object object = new Request.Builder().endpoint("/chats").method("POST");
            List list = state.getStateItems();
            Arrays.asList(State.getUserDataKeys());
            for (int i = 0; i < state.getStateItems().size(); ++i) {
                RequestParameter requestParameter;
                String string2 = ((State.StateItem)list.get(i)).getKey();
                Object object2 = ((State.StateItem)list.get(i)).getValue();
                if (string2 == null || object2 == null) continue;
                RequestParameter requestParameter2 = requestParameter;
                requestParameter = new RequestParameter(string2, object2);
                object.addParameter(requestParameter2);
            }
            state = object.build();
            object = callbacks2;
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                public void onSucceeded(RequestResponse requestResponse) {
                    block6: {
                        if (requestResponse != null) {
                            InstabugSDKLogger.d((String)"IBG-BR", (String)("triggeringChatRequest Succeeded, Response code: " + requestResponse.getResponseCode()));
                            InstabugSDKLogger.v((String)"IBG-BR", (String)("triggeringChatRequest Succeeded, Response body: " + requestResponse.getResponseBody()));
                            if (requestResponse.getResponseCode() == 200) {
                                try {
                                    if (requestResponse.getResponseBody() == null) break block6;
                                }
                                catch (JSONException jSONException) {}
                                callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("chat_number"));
                            } else {
                                callbacks.onFailed((Object)new Throwable("Triggering chat got error with response code:" + requestResponse.getResponseCode()));
                            }
                        }
                    }
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("triggeringChatRequest got error: " + throwable.getMessage()));
                    callbacks.onFailed((Object)throwable);
                }
            };
            this.networkManager.doRequest("CHATS", 1, (Request)state, (Request.Callbacks)object);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void sendMessage(Message message, final Request.Callbacks<String, Throwable> callbacks) {
        if (message != null && callbacks != null) {
            Request.Callbacks<RequestResponse, Throwable> callbacks2;
            InstabugSDKLogger.d((String)"IBG-BR", (String)"Sending message");
            String string2 = message.getChatId();
            Request.Builder builder = new Request.Builder().endpoint("/chats/:chat_number/messages".replaceAll(":chat_number", string2)).method("POST").tokenProvider(() -> message.getAppToken() == null ? TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken() : message.getAppToken());
            long l = message.getMessagedAt();
            builder.addParameter(new RequestParameter("message", (Object)new JSONObject().put("body", (Object)message.getBody()).put("messaged_at", l).put("email", (Object)message.getRequesterEmail()).put("name", (Object)message.getRequesterName()).put("push_token", (Object)message.getDeviceToken())));
            message = builder.build();
            Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                public void onSucceeded(RequestResponse object) {
                    block7: {
                        if (object != null) {
                            InstabugSDKLogger.d((String)"IBG-BR", (String)("sendMessage request Succeeded, Response code: " + object.getResponseCode()));
                            InstabugSDKLogger.v((String)"IBG-BR", (String)("sendMessage request Succeeded, Response body: " + object.getResponseBody()));
                            if (object.getResponseCode() == 200) {
                                object = object.getResponseBody();
                                if (!(object instanceof String)) break block7;
                                try {
                                    callbacks.onSucceeded((Object)new JSONObject((String)object).getString("message_id"));
                                }
                                catch (JSONException jSONException) {
                                    InstabugSDKLogger.e((String)"IBG-BR", (String)("Sending message got error: " + jSONException.getMessage()));
                                }
                            } else {
                                callbacks.onFailed((Object)new Throwable("Sending message got error with response code:" + object.getResponseCode()));
                            }
                        }
                    }
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("sendMessage request got error: " + throwable.getMessage()));
                    callbacks.onFailed((Object)throwable);
                }
            };
            this.networkManager.doRequest("CHATS", 1, (Request)message, (Request.Callbacks)callbacks3);
        }
    }

    public synchronized void uploadMessageAttachments(final Message message, final Request.Callbacks<Boolean, Message> callbacks) {
        if (message != null && callbacks != null) {
            ArrayList arrayList;
            InstabugSDKLogger.v((String)"IBG-BR", (String)"Uploading message attachments");
            final ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            for (int i = 0; i < message.getAttachments().size(); ++i) {
                File file;
                Object object;
                final Attachment attachment = message.getAttachments().get(i);
                InstabugSDKLogger.v((String)"IBG-BR", (String)("Uploading attachment with type: " + attachment.getType()));
                if (attachment.getType() == null || attachment.getName() == null || attachment.getLocalPath() == null || attachment.getFileType() == null || message.getChatId() == null) continue;
                String string2 = message.getChatId();
                string2 = new Request.Builder().method("POST").type(2).endpoint("/chats/:chat_number/messages/:message_id/attachments".replaceAll(":chat_number", string2).replaceAll(":message_id", String.valueOf(message.getId()))).tokenProvider(() -> message.getAppToken() == null ? TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken() : message.getAppToken());
                string2.addParameter(new RequestParameter("metadata[file_type]", (Object)attachment.getType()));
                if (attachment.getType().equals("audio") && attachment.getDuration() != null) {
                    RequestParameter requestParameter;
                    object = requestParameter;
                    requestParameter = new RequestParameter("metadata[duration]", (Object)attachment.getDuration());
                    string2.addParameter((RequestParameter)object);
                }
                Attachment attachment2 = attachment;
                object = attachment2.getName();
                String string3 = attachment2.getLocalPath();
                String string4 = attachment2.getFileType();
                string2.fileToUpload(new FileToUpload("file", (String)object, string3, string4));
                InstabugSDKLogger.v((String)"IBG-BR", (String)("Uploading attachment with name: " + attachment.getName() + " path: " + attachment.getLocalPath() + " file type: " + attachment.getFileType()));
                object = file;
                if (new File(attachment.getLocalPath()).exists() && ((File)object).length() > 0L) {
                    Request.Callbacks<RequestResponse, Throwable> callbacks2;
                    attachment.setState("synced");
                    string2 = string2.build();
                    object = callbacks2;
                    callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                        public void onSucceeded(RequestResponse requestResponse) {
                            3 v0 = this;
                            InstabugSDKLogger.d((String)"IBG-BR", (String)("uploadingMessageAttachmentRequest succeeded, Response code: " + requestResponse.getResponseCode()));
                            InstabugSDKLogger.v((String)"IBG-BR", (String)("uploadingMessageAttachmentRequest succeeded, Response body: " + requestResponse.getResponseBody()));
                            v0.arrayList2.add(attachment);
                            if (v0.arrayList2.size() == message.getAttachments().size()) {
                                callbacks.onSucceeded((Object)Boolean.TRUE);
                            }
                        }

                        public void onFailed(Throwable throwable) {
                            3 v0 = this;
                            InstabugSDKLogger.v((String)"IBG-BR", (String)("uploadingMessageAttachmentRequest got error: " + throwable.getMessage()));
                            v0.arrayList2.add(attachment);
                            if (v0.arrayList2.size() == message.getAttachments().size()) {
                                callbacks.onFailed((Object)message);
                            }
                        }
                    };
                    this.networkManager.doRequest("CHATS", 2, (Request)string2, (Request.Callbacks)object);
                    continue;
                }
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
            }
        }
    }

    public void syncMessages(long l, int n, JSONArray jSONArray, final Request.Callbacks<RequestResponse, Throwable> callbacks) {
        if (jSONArray != null && callbacks != null) {
            Request.Callbacks<RequestResponse, Throwable> callbacks2;
            InstabugSDKLogger.d((String)"IBG-BR", (String)"Syncing messages with server");
            Request request = MessagingServiceUtil.buildSyncMessagesRequest(l, n, jSONArray);
            Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                public void onSucceeded(RequestResponse requestResponse) {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("syncMessages request Succeeded, Response code: " + requestResponse.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("syncMessages request Succeeded, Response body: " + requestResponse.getResponseBody()));
                    callbacks.onSucceeded((Object)requestResponse);
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("syncMessages request got error: " + throwable.getMessage()));
                    callbacks.onFailed((Object)throwable);
                }
            };
            this.networkManager.doRequest("CHATS", 1, request, (Request.Callbacks)callbacks3);
        }
    }

    public void uploadChatLogs(final Chat chat, final Request.Callbacks<Boolean, Chat> callbacks) {
        if (chat != null && callbacks != null) {
            Request.Callbacks<RequestResponse, Throwable> callbacks2;
            String string2 = chat.getId();
            string2 = new Request.Builder().method("POST").endpoint("/chats/:chat_token/state_logs".replaceAll(":chat_token", string2));
            if (chat.getState() != null) {
                for (Object object : chat.getState().getLogsItems()) {
                    RequestParameter requestParameter;
                    if (object.getKey() == null || object.getKey().equals("user_repro_steps") || object.getKey().equals("sessions_profiler") || object.getValue() == null) continue;
                    RequestParameter requestParameter2 = requestParameter;
                    State.StateItem stateItem = object;
                    object = stateItem.getKey();
                    requestParameter = new RequestParameter((String)object, stateItem.getValue());
                    string2.addParameter(requestParameter2);
                }
            }
            string2 = string2.build();
            Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                public void onSucceeded(RequestResponse requestResponse) {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("uploading chat logs onNext, Response code: " + requestResponse.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("uploading chat logs onNext, Response body: " + requestResponse.getResponseBody()));
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("uploading chat logs got error: " + throwable.getMessage()));
                    callbacks.onFailed((Object)chat);
                }
            };
            this.networkManager.doRequest("CHATS", 1, (Request)string2, (Request.Callbacks)callbacks3);
        }
    }

    public synchronized void sendPushNotificationToken(String string2, final Request.Callbacks<Boolean, Throwable> callbacks) {
        if (string2 != null && callbacks != null) {
            Request.Callbacks<RequestResponse, Throwable> callbacks2;
            string2 = new Request.Builder().endpoint("/push_token").method("POST").addParameter(new RequestParameter("push_token", (Object)string2)).build();
            Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                public void onSucceeded(RequestResponse requestResponse) {
                    if (requestResponse != null) {
                        InstabugSDKLogger.d((String)"IBG-BR", (String)"Sending push notification request Succeeded");
                        if (requestResponse.getResponseCode() == 200) {
                            callbacks.onSucceeded((Object)Boolean.TRUE);
                        } else {
                            InstabugSDKLogger.e((String)"IBG-BR", (String)("sending push notification token got error with response code: " + requestResponse.getResponseCode()));
                        }
                    }
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("sending push notification token got error: " + throwable.getMessage()));
                }
            };
            this.networkManager.doRequestOnSameThread(1, (Request)string2, (Request.Callbacks)callbacks3);
        }
    }
}

