/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat;

import android.content.Context;
import android.os.Bundle;
import com.instabug.chat.ChatPlugin;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.network.InstabugPushNotificationTokenJob;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.settings.AttachmentTypesState;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.ui.ChatActivityLauncher;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.threading.PoolProvider;
import java.util.Map;

public abstract class ChatsDelegate {
    public static void showChats() {
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ChatsDelegate.isReadyToRun() && (this = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class)) != null && (this = this.getAppContext()) != null) {
                    Object object = this;
                    object.startActivity(ChatActivityLauncher.chatsProcessIntent((Context)object));
                }
            }
        });
    }

    public static void setOnSdkDismissCallback(OnSdkDismissCallback onSdkDismissCallback) {
        ChatSettings.setOnSdkDismissCallback(onSdkDismissCallback);
    }

    public static int getUnreadMessagesCount() {
        if (ChatsDelegate.isReadyToRun()) {
            return ChatsCacheManager.getUnreadCount();
        }
        return 0;
    }

    public static void enableNotification(boolean bl) {
        if (ChatsDelegate.isReadyToRun()) {
            ChatSettings.enableNotification(bl);
        }
    }

    public static void enableInAppNotificationSound(boolean bl) {
        if (ChatsDelegate.isReadyToRun()) {
            ChatSettings.enableInAppNotificationSound(bl);
        }
    }

    public static void setPushNotificationRegistrationToken(String object) {
        if (ChatsDelegate.isReadyToRun() && object != null && !((String)object).isEmpty() && !((String)object).equalsIgnoreCase(InstabugCore.getPushNotificationToken())) {
            InstabugCore.setPushNotificationToken((String)object);
            InstabugCore.setPushNotificationTokenSent((boolean)false);
            object = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
            if (object != null && object.getAppContext() != null && InstabugCore.getFeatureState((String)"PUSH_NOTIFICATION") == Feature.State.ENABLED) {
                InstabugPushNotificationTokenJob.getInstance().start();
            }
        }
    }

    public static void showNotification(Bundle bundle) {
        if (ChatsDelegate.isReadyToRun()) {
            NotificationManager.getInstance().showNotification(bundle);
        }
    }

    public static void showNotification(Map<String, String> map) {
        if (ChatsDelegate.isReadyToRun()) {
            NotificationManager.getInstance().showNotification(map);
        }
    }

    private static boolean isReadyToRun() {
        ChatPlugin chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
        if (chatPlugin != null) {
            return chatPlugin.isAppContextAvailable() && ChatsDelegate.isChatFeatureEnabled();
        }
        return false;
    }

    private static boolean isChatFeatureEnabled() {
        return InstabugCore.getFeatureState((String)"IN_APP_MESSAGING") == Feature.State.ENABLED;
    }

    public static void setNewMessageHandler(Runnable runnable) {
        ChatSettings.setNewMessageRunnable(runnable);
    }

    public static void setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3) {
        ChatSettings.setAttachmentsTypesParams(new AttachmentTypesState(bl, bl2, bl3));
    }

    public static void dismissSystemNotification() {
        NotificationManager.getInstance().dismissSystemNotification(Instabug.getApplicationContext());
    }
}

