package com.instabug.chat.util

import android.view.View
import androidx.annotation.RequiresApi
import androidx.core.graphics.Insets
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.WindowInsetsCompat.Type.InsetsType
import androidx.core.view.updatePadding


val allInsetsTypeApplied =
    (WindowInsetsCompat.Type.ime() or
            WindowInsetsCompat.Type.systemBars() or
            WindowInsetsCompat.Type.displayCutout())

@RequiresApi(api = 35)
fun View.addSystemWindowInsetToPadding(
    left: Boolean = false,
    top: Boolean = false,
    right: Boolean = false,
    bottom: Boolean = false,
) {
    this.addSystemWindowInsetToPadding(
        left = left,
        top = top,
        right = right,
        bottom = bottom,
        insetType = allInsetsTypeApplied,
        callBack = null
    )
}

@RequiresApi(api = 35)
fun View.addSystemWindowInsetToPadding(
    left: Boolean = false,
    top: Boolean = false,
    right: Boolean = false,
    bottom: Boolean = false,
    callBack: ((Insets) -> Unit)? = null
) {
    this.addSystemWindowInsetToPadding(
        left = left,
        top = top,
        right = right,
        bottom = bottom,
        insetType = allInsetsTypeApplied,
        callBack = callBack
    )
}

@RequiresApi(api = 35)
fun View.addSystemWindowInsetToPadding(
    left: Boolean = false,
    top: Boolean = false,
    right: Boolean = false,
    bottom: Boolean = false,
    @InsetsType insetType: Int
) {
    addSystemWindowInsetToPadding(
        left = left,
        top = top,
        right = right,
        bottom = bottom,
        insetType = insetType,
        callBack = null
    )
}

@RequiresApi(api = 35)
fun View.addSystemWindowInsetToPadding(
    left: Boolean = false,
    top: Boolean = false,
    right: Boolean = false,
    bottom: Boolean = false,
    @InsetsType insetType: Int = allInsetsTypeApplied,
    callBack: ((Insets) -> Unit)? = null
) {
    val initialLeft = paddingLeft
    val initialTop = paddingTop
    val initialRight = paddingRight
    val initialBottom = paddingBottom

    ViewCompat.setOnApplyWindowInsetsListener(this) { view, windowInsets ->
        val insets = windowInsets.getInsets(
            insetType
        )

        view.updatePadding(
            left = initialLeft.addInset(left, insets.left),
            top = initialTop.addInset(top, insets.top),
            right = initialRight.addInset(right, insets.right),
            bottom = initialBottom.addInset(bottom, insets.bottom)
        )
        callBack?.invoke(insets)
        WindowInsetsCompat.CONSUMED
    }
}

fun Int.addInset(applyInset: Boolean, inset: Int): Int =
    this + if (applyInset) inset.coerceAtLeast(0) else 0

