package com.instabug.chat.annotation.shape;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;

import com.instabug.chat.annotation.ColorPickerPopUpView;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.utility.BitmapUtility;
import com.instabug.library.util.DrawingUtility;
import com.instabug.library.settings.SettingsManager;

import androidx.annotation.Nullable;

/**
 Created by tarek on 11/6/16.
 */

public class BlurredRectShape extends CroppedRectShape {

    private static final int BLURRING_RADIUS = 18;
    private final Context context;

    public BlurredRectShape(@Nullable Bitmap background, Context context) {
        super(ColorPickerPopUpView.DEFAULT_COLOR);
        this.context = context;
        if (background != null) {
            this.background = BitmapUtility.blur(background, BLURRING_RADIUS, context);
            setRecognized(true);
        }
    }

    public void setBackground(@Nullable Bitmap background) {
        if (background != null) {
            this.background = BitmapUtility.blur(background, BLURRING_RADIUS, context);
        }
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void drawCroppedRect(Canvas canvas, Bitmap croppedBitmap, float drawX, float drawY) {
        canvas.drawBitmap(croppedBitmap, drawX, drawY, null);
    }

    @Override
    public void adjustBounds(DirectionRectF src, DirectionRectF dst, boolean isUndo) {
        dst.set(src);
    }

    @Override
    public void drawControlButtons(Canvas canvas, DirectionRectF bounds,
                                   ControlButton[] controlButtons) {

        PointF[] controlPoints = bounds.getCornersPoints();

        for (int i = 0; i < controlButtons.length; i++) {
            controlButtons[i].setCenterPoint(controlPoints[i]);
            controlButtons[i].setColor(SettingsManager.getInstance().getPrimaryColor());
            controlButtons[i].draw(canvas);
        }
    }

    @Override
    public void drawBorder(Canvas canvas, PointF topLeftPoint, PointF topRightPoint,
                           PointF bottomRightPoint, PointF bottomLeftPoint) {

        DrawingUtility.drawLine(canvas, topLeftPoint, topRightPoint, borderPaint);
        DrawingUtility.drawLine(canvas, topLeftPoint, bottomLeftPoint, borderPaint);
        DrawingUtility.drawLine(canvas, topRightPoint, bottomRightPoint, borderPaint);
        DrawingUtility.drawLine(canvas, bottomRightPoint, bottomLeftPoint, borderPaint);
    }

    @Override
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public Path getPath(DirectionRectF bounds) {
        return null;
    }
}
