package com.instabug.bug.view.visualusersteps.steppreview;

import android.content.Context;
import android.graphics.Bitmap;

import androidx.annotation.Nullable;

import com.instabug.bug.Constants;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;

import java.util.concurrent.Callable;

import io.reactivexport.Observable;
import io.reactivexport.android.schedulers.AndroidSchedulers;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;
import io.reactivexport.schedulers.Schedulers;

/**
 Created by Barakat on 21/05/2019
 */
public class VisualUserStepPreviewPresenter extends
        BasePresenter<VisualUserStepPreviewContract.View>
        implements VisualUserStepPreviewContract.Presenter {
    @Nullable
    private Disposable stepDisposable;

    public VisualUserStepPreviewPresenter(VisualUserStepPreviewContract.View view) {
        super(view);
    }

    @Override
    public void loadPreviewBitmap(String path) {
        if (view != null) {
            final VisualUserStepPreviewContract.View viewRef = this.view.get();
            if (viewRef != null) {
                viewRef.toggleProgress(true);
                stepDisposable = stepObservable(path)
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .doOnError(new Consumer<Throwable>() {
                            @Override
                            public void accept(Throwable throwable) throws Exception {
                                InstabugSDKLogger.e(Constants.LOG_TAG, "Error: " + throwable.getMessage() + ", while previewing bitmap");
                                viewRef.close();
                            }
                        })
                        .subscribe(new Consumer<Bitmap>() {
                            @Override
                            public void accept(Bitmap bitmap) {
                                viewRef.toggleProgress(false);
                                viewRef.onBitmapLoaded(bitmap);
                            }
                        });
            }
        }
    }

    @Override
    public void release() {
        if (stepDisposable != null && !stepDisposable.isDisposed()) {
            stepDisposable.dispose();
        }
    }

    private Observable<Bitmap> stepObservable(final String path) {
        return Observable.fromCallable(new Callable<Bitmap>() {
            @Override
            public Bitmap call() {
                return VisualUserStepsHelper.decryptBitmap(path);
            }
        });
    }


}
