package com.instabug.bug.view.floatingactionbutton;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;

import com.instabug.library.R;


public class StopFloatingActionButton extends FloatingActionButton {

    public StopFloatingActionButton(Context context) {
        this(context, null);
    }

    public StopFloatingActionButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public StopFloatingActionButton(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    void init(Context context, @Nullable AttributeSet attributeSet) {
        super.init(context, attributeSet);
        setSize(SIZE_MINI);
        setId(R.id.instabug_video_stop_button);
        setNextFocusForwardId(R.id.instabug_floating_button);
    }

    @Override
    @StringRes
    public int getButtonContentDescription() {
        return R.string.ibg_scren_recording_stop_btn_content_description;
    }

    @Override
    Drawable getIconDrawable() {

        final float iconSize = getDimension(R.dimen.instabug_fab_icon_size_mini);
        final float fabSize = getDimension(R.dimen.instabug_fab_size_mini);

        final float iconHalfSize = iconSize / 2f;

        final float strokeWidth = getDimension(R.dimen.instabug_fab_circle_icon_stroke);

        final Shape shape = new Shape() {
            @Override
            public void draw(Canvas canvas, Paint paint) {

                if (isEnabled()) {
                    paint.setColor(Color.RED);
                } else {
                    paint.setColor(Color.parseColor("#D1D1D6"));
                }
                paint.setStyle(Style.STROKE);
                paint.setStrokeWidth(strokeWidth);
                canvas.drawCircle(iconHalfSize, iconHalfSize, fabSize / 2, paint);

                paint.setStyle(Style.FILL);
                RectF rectF = new RectF(0, 0, iconSize, iconSize);
                rectF.inset(strokeWidth / 2, strokeWidth / 2);
                canvas.drawRoundRect(rectF, 4, 4, paint);
            }
        };

        ShapeDrawable drawable = new ShapeDrawable(shape);

        final Paint paint = drawable.getPaint();
        paint.setAntiAlias(true);

        return drawable;
    }
}
