package com.instabug.bug.view.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.Gravity;

import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;

import com.instabug.library.R;


public class RecordingFloatingActionButton extends FloatingActionButton {

    @Nullable
    private RecordingState recordingState;
    @Nullable
    private Paint textPaint;
    @Nullable
    private String text;
    private float strokeWidth;

    public RecordingFloatingActionButton(Context context) {
        this(context, null);
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public RecordingFloatingActionButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public RecordingFloatingActionButton(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    void init(Context context, @Nullable AttributeSet attributeSet) {
        super.init(context, attributeSet);
        textPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        textPaint.setColor(Color.WHITE);
        textPaint.setTextAlign(Paint.Align.CENTER);
        textPaint.setTextSize(context.getResources().getDimension(R.dimen.instabug_fab_text_size));

        strokeWidth = getDimension(R.dimen.instabug_fab_circle_icon_stroke);
        setTypeface(ResourcesCompat.getFont(context, R.font.ibg_video_icon));

        setText("\ue900", false);
        setTextColor(Color.WHITE);
        setGravity(Gravity.CENTER);

    }

    @Override
    Drawable getIconDrawable() {
        final float fabSize;
        final float iconSize;

        if (getSize() == SIZE_NORMAL) {
            fabSize = getDimension(R.dimen.instabug_fab_size_normal);
            iconSize = getDimension(R.dimen.instabug_fab_icon_size_normal);
        } else {
            fabSize = getDimension(R.dimen.instabug_fab_size_mini);
            iconSize = getDimension(R.dimen.instabug_fab_icon_size_mini);
        }
        final float iconHalfSize = iconSize / 2f;

        final float strokeWidth = getDimension(R.dimen.instabug_fab_circle_icon_stroke);

        final Shape shape = new Shape() {
            @Override
            public void draw(Canvas canvas, Paint paint) {
                paint.setColor(Color.RED);

                paint.setStyle(Paint.Style.FILL_AND_STROKE);
                paint.setStrokeWidth(strokeWidth);
                canvas.drawCircle(iconHalfSize, iconHalfSize, fabSize / 2, paint);

                if (recordingState == RecordingState.RECORDING) {
                    setText(null, false);
                } else {
                    setText("\ue900", false);
                }

            }
        };

        ShapeDrawable drawable = new ShapeDrawable(shape);

        final Paint paint = drawable.getPaint();
        paint.setAntiAlias(true);

        return drawable;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (text != null && textPaint != null) {
            int xPos = (canvas.getWidth() / 2);
            int yPos = (int) ((canvas.getHeight() / 2f)
                    - ((textPaint.descent() + textPaint.ascent()) / 2f)
                    - strokeWidth);
            canvas.drawText(text, xPos, yPos, textPaint);
        }
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void setText(@Nullable String text, boolean shouldInvalidate) {
        if (shouldInvalidate) {
            this.text = text;
            invalidate();
        } else {
            super.setText(text);
        }
    }

    public void setRecordingState(RecordingState recordingState) {
        this.recordingState = recordingState;
        updateBackground();
    }

    public enum RecordingState {
        RECORDING, STOPPED
    }
}
