package com.instabug.bug.utils

import android.content.Context
import com.instabug.library.internal.storage.AttachmentManager
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.util.FileUtils

object CleanUpUtils {

    @JvmStatic
    fun cleanupUnsentBugsFiles(context: Context?) {
        context?.let { ctx ->
            cleanupAutoRecordingDirectory(ctx)
            cleanupVideosDirectory(ctx)
            cleanupInitialScreenshots(ctx)
            cleanupViewHierarchyAttachments(ctx)
        }
    }

    private fun cleanupAutoRecordingDirectory(context: Context) {
        FileUtils.deleteDirectory(AttachmentManager.getAutoScreenRecordingVideosDirectory(context))
    }

    private fun cleanupVideosDirectory(context: Context) {
        FileUtils.deleteDirectory(AttachmentManager.getNewInternalDirectory(context, "videos"))
    }

    private fun cleanupInitialScreenshots(context: Context) {
        val instabugDirectory = DiskUtils.getInstabugInternalDirectory(context)
        val filesToDelete =
            instabugDirectory.listFiles { _, name -> name?.startsWith("bug_") ?: false }
        filesToDelete?.asSequence()
            ?.forEach { file -> file.delete() }
    }

    private fun cleanupViewHierarchyAttachments(context: Context) {
        val instabugDirectory = DiskUtils.getInstabugInternalDirectory(context)
        val filesToDelete = instabugDirectory.listFiles { _, name ->
            name?.startsWith("view_hierarchy_attachment") ?: false
        }
        filesToDelete?.asSequence()
            ?.forEach { file -> file.delete() }
    }
}