package com.instabug.bug.invocation.invoker;

import org.jetbrains.annotations.NotNull;

import java.util.Locale;
import java.util.regex.Pattern;

public class ScreenshotObserverHelper {
    private static final String FILE_NAME_PREFIX = "screenshot";
    // Regex to match on "screenshots/" or "screenshot/"
    private static final String SCREENSHOT_DIR_PATH = "screenshot(s?| |$)\\/";
    private static final Pattern COMPILE = Pattern.compile(SCREENSHOT_DIR_PATH);

    protected static boolean isScreenshotFile(@NotNull String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).startsWith(FILE_NAME_PREFIX);
    }

    protected static boolean isScreenshotDir(@NotNull String path) {
        return COMPILE.matcher(path.toLowerCase(Locale.getDefault())).find();
    }
}
