/*
 * Copyright (c) 2017 Yrom Wang <http://www.yrom.net>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.instabug.bug.internal.video.customencoding;

import static android.media.MediaCodecInfo.CodecProfileLevel.AACObjectMain;
import static android.media.MediaFormat.MIMETYPE_AUDIO_AAC;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.os.Build;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
public class AudioEncodeConfig {

    private static final int AUDIO_ENCODING_BITRATE = 80000;
    private static final int AUDIO_SAMPLING_RATE = 44100;
    private static final int AUDIO_CHANNELS_COUNT = 2;
    private static final String AUDIO_CODEC_NAME = "OMX.google.aac.encoder";
    private static final String AUDIO_MIME_TYPE = MIMETYPE_AUDIO_AAC;
    private static final int AUDIO_PROFILE = AACObjectMain;

    final String codecName;

    public AudioEncodeConfig() {
        this.codecName = AUDIO_CODEC_NAME;
    }

    MediaFormat toFormat() {
        MediaFormat format = MediaFormat.createAudioFormat(AUDIO_MIME_TYPE, AUDIO_SAMPLING_RATE, AUDIO_CHANNELS_COUNT);
        format.setInteger(MediaFormat.KEY_AAC_PROFILE, AUDIO_PROFILE);
        format.setInteger(MediaFormat.KEY_BIT_RATE, AUDIO_ENCODING_BITRATE);
        return format;
    }

    @Override
    public String toString() {
        return "AudioEncodeConfig{" +
                "codecName='" + codecName + '\'' +
                ", mimeType='" + AUDIO_MIME_TYPE + '\'' +
                ", bitRate=" + AUDIO_ENCODING_BITRATE +
                ", sampleRate=" + AUDIO_SAMPLING_RATE +
                ", channelCount=" + AUDIO_CHANNELS_COUNT +
                ", profile=" + AUDIO_PROFILE +
                '}';
    }

    public int getSamplingRate() {
        return AUDIO_SAMPLING_RATE;
    }

    public int getChannelCount() {
        return AUDIO_CHANNELS_COUNT;
    }
}
