package com.instabug.bug.userConsent

import androidx.annotation.StringDef
import com.instabug.bug.userConsent.ActionType.Companion.DROP_AUTO_CAPTURED_MEDIA
import com.instabug.bug.userConsent.ActionType.Companion.NO_CHAT
import com.instabug.bug.userConsent.ActionType.Companion.DROP_LOGS


@Retention(AnnotationRetention.SOURCE)
@Target(AnnotationTarget.TYPE)
@StringDef(
    DROP_AUTO_CAPTURED_MEDIA,
    DROP_LOGS,
    NO_CHAT
)
annotation class ActionType {
    companion object {

        const val DROP_AUTO_CAPTURED_MEDIA = "drop_auto_captured_media"
        const val DROP_LOGS = "drop_logs"
        const val NO_CHAT = "no_chat"
    }
}

