package com.instabug.bug.onboardingbugreporting;

import android.annotation.SuppressLint;
import android.os.Handler;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.bug.R;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.library.util.PlaceHolderUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


@SuppressLint({"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_NO_DEFAULT"})
public class OnBoardingPresenter extends BasePresenter<OnBoardingActivityContract.View> implements OnBoardingActivityContract.Presenter {

    @Nullable
    private final OnBoardingActivityContract.View viewInstance;

    public OnBoardingPresenter(OnBoardingActivityContract.View view) {
        super(view);
        viewInstance = this.view.get();
    }


    @Override
    public void startWithBetaVersion() {
        List<OnboardingPagerFragment> betaFragments = getBetaFragments();
        if (viewInstance != null) {
            viewInstance.loadViewPager(betaFragments);
        }
    }
    private List<OnboardingPagerFragment> getBetaFragments() {
        List<OnboardingPagerFragment> betaFragments = new ArrayList<>();
        betaFragments.add(getWelcomeFragment());
        betaFragments.add(getBetaInvocationFragment());
        betaFragments.add(getFinishingStepFragment());
        return betaFragments;
    }


    private OnboardingPagerFragment getWelcomeFragment() {
        String title = null;
        String content = null;
        if (viewInstance != null) {
            title = PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_WELCOME_STEP_TITLE,
                    viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_step_title));
            content = PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_WELCOME_STEP_CONTENT,
                    viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_step_content));
        }
        return OnboardingPagerFragment.newInstance(
                InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight
                        ? R.drawable.ibg_bg_ic_onboarding_welcome
                        : R.drawable.ibg_bg_ic_onboarding_welcome_dark, title, content);
    }
    private OnboardingPagerFragment getBetaInvocationFragment() {
        int drawableRes = getInvocationDrawable(getHighestPriorityInvocationEvent(getCurrentInvocationEvents()));
        String content = null;
        String title = null;

        if (viewInstance != null) {
            title = PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_TITLE,
                    viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_title));
            switch (getHighestPriorityInvocationEvent(getCurrentInvocationEvents())) {
                case FLOATING_BUTTON:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_floating));
                    break;
                case SCREENSHOT:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_screenshot));
                    break;
                case TWO_FINGER_SWIPE_LEFT:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_swipe));
                    break;
                case SHAKE:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_shake));
                    break;
            }
        }
        return OnboardingPagerFragment.newInstance(drawableRes, title, content);
    }
    private @DrawableRes
    int getInvocationDrawable(InstabugInvocationEvent invocationEvent) {
        switch (invocationEvent) {
            case FLOATING_BUTTON:
                return InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight
                        ? R.drawable.ibg_bg_ic_onboarding_floating_btn
                        : R.drawable.ibg_bg_ic_onboarding_floating_btn_dark;
            case SCREENSHOT:
                return InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight
                        ? R.drawable.ibg_bg_ic_onboarding_screenshot
                        : R.drawable.ibg_bg_ic_onboarding_screenshot_dark;
            case TWO_FINGER_SWIPE_LEFT:
                return InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight
                        ? R.drawable.ibg_bg_ic_onboarding_swipe
                        : R.drawable.ibg_bg_ic_onboarding_swipe_dark;
            default:
            case SHAKE:
                return InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight
                        ? R.drawable.ibg_bg_ic_onboarding_shake
                        : R.drawable.ibg_bg_ic_onboarding_shake_dark;
        }
    }
    @VisibleForTesting
    InstabugInvocationEvent getHighestPriorityInvocationEvent(List<InstabugInvocationEvent> instabugInvocationEventList) {
        if (instabugInvocationEventList.size() == 1) {
            return instabugInvocationEventList.get(0);
        } else {
            if (instabugInvocationEventList.contains(InstabugInvocationEvent.SHAKE)) {
                return InstabugInvocationEvent.SHAKE;
            } else if (instabugInvocationEventList.contains(InstabugInvocationEvent.SCREENSHOT)) {
                return InstabugInvocationEvent.SCREENSHOT;
            } else if (instabugInvocationEventList.contains(InstabugInvocationEvent.TWO_FINGER_SWIPE_LEFT)) {
                return InstabugInvocationEvent.TWO_FINGER_SWIPE_LEFT;
            } else {
                return InstabugInvocationEvent.FLOATING_BUTTON;
            }
        }
    }
    @VisibleForTesting
    @SuppressLint("NULL_DEREFERENCE")
    List<InstabugInvocationEvent> getCurrentInvocationEvents() {
        if (InvocationManager.getInstance().getCurrentInstabugInvocationEvents() != null) {
            return Arrays.asList(InvocationManager.getInstance().getCurrentInstabugInvocationEvents());
        } else {
            return new ArrayList<>();
        }
    }
    private OnboardingPagerFragment getFinishingStepFragment() {
        String title = null;
        String content = null;
        if (viewInstance != null) {
            title = PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_FINISH_STEP_TITLE,
                    viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_finishing_step_title));
            content = PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.BETA_WELCOME_MESSAGE_FINISH_STEP_CONTENT,
                    viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_finishing_step_content));
        }
        return OnboardingPagerFragment.newInstance(
                InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight ? R.drawable.ibg_bg_ic_onboarding_stay_updated
                        : R.drawable.ibg_bg_ic_onboarding_stay_updated_dark, title, content);
    }


    @Override
    public void startWithLiveVersion() {
        List<OnboardingPagerFragment> liveFragments = getLiveFragment();

        if (viewInstance != null) {
            viewInstance.loadViewPager(liveFragments);
            new Handler().postDelayed(new Runnable() {
                @Override
                @SuppressLint("NULL_DEREFERENCE")
                public void run() {
                    if (viewInstance != null) {
                        viewInstance.dismiss();
                    }
                }
            }, 5000);

        }
    }

    @Override
    public void start(@State int state) {
        handlePowerByInstabugFooter();
        switch (state) {
            case State.BETA:
                startWithBetaVersion();
                break;
            case State.LIVE:
                startWithLiveVersion();
                enableClickToClose();
                break;
            default:

        }
    }
    private void handlePowerByInstabugFooter() {
        if (viewInstance != null)
            viewInstance.handlePowerByInstabugFooter();
    }
    private void enableClickToClose() {
        if (viewInstance != null) {
            viewInstance.enableClickToClose();
        }
    }
    private OnboardingPagerFragment getLiveInvocationFragment() {
        int drawableRes = getInvocationDrawable(getHighestPriorityInvocationEvent(getCurrentInvocationEvents()));
        String content = null;
        String title = null;
        if (viewInstance != null) {
            title = PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.LIVE_WELCOME_MESSAGE_TITLE,
                    viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_live_welcome_message_title));

            switch (getHighestPriorityInvocationEvent(getCurrentInvocationEvents())) {
                case FLOATING_BUTTON:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.LIVE_WELCOME_MESSAGE_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_floating));
                    break;
                case SCREENSHOT:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.LIVE_WELCOME_MESSAGE_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_screenshot));
                    break;
                case TWO_FINGER_SWIPE_LEFT:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.LIVE_WELCOME_MESSAGE_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_swipe));
                    break;
                case SHAKE:
                    content = PlaceHolderUtils.getPlaceHolder(
                            InstabugCustomTextPlaceHolder.Key.LIVE_WELCOME_MESSAGE_CONTENT,
                            viewInstance.getLocalizedString(com.instabug.library.R.string.ib_str_beta_welcome_how_to_report_step_content_shake));
                    break;
            }
        }
        return OnboardingPagerFragment.newInstance(drawableRes, title, content, true);
    }
    private List<OnboardingPagerFragment> getLiveFragment() {
        List<OnboardingPagerFragment> liveFragments = new ArrayList<>();
        liveFragments.add(getLiveInvocationFragment());
        return liveFragments;
    }

}


