package com.instabug.bug.view.visualusersteps.visitedscreens;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_DESCRIPTION;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_EMPTY_STATE_DESCRIPTION;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_PROGRESS_DIALOG_BODY;
import static com.instabug.library.util.FileUtils.FLAG_ENCRYPTED;
import static com.instabug.library.util.ThemeApplier.applyPrimaryTextStyle;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.instabug.bug.R;
import com.instabug.bug.model.VisitedScreen;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.reporting.ReportingContainerActivity;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.view.IBGProgressDialog;

import java.util.ArrayList;

/**
 * Created by Barakat on 01/05/2019
 */
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class VisualUserStepsListFragment extends InstabugBaseFragment<VisualUserStepsListPresenter>
        implements VisualUserStepsListContract.View {

    public static final String TAG = "visual_user_steps";

    @VisibleForTesting
    @Nullable
    private String title;
    private static final String KEY_TITLE = "title";
    @Nullable
    private BugReportingActivityCallback activityCallback;
    private String currentTitle = "";
    private VisualUserStepsListAdapter adapter;
    private RecyclerView stepsList;
    private TextView emptyView;
    private LinearLayout container;
    private IBGProgressDialog preparingProgressDialog;

    public static VisualUserStepsListFragment newInstance(String title) {
        Bundle args = new Bundle();
        args.putString(KEY_TITLE, title);

        VisualUserStepsListFragment fragment = new VisualUserStepsListFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
        if (getActivity() != null) {
            getActivity().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
        }

        title = getArguments() == null ? "" : getArguments().getString(KEY_TITLE);
        if (activityCallback != null) {
            currentTitle = activityCallback.getToolbarTitle();
            if (title != null) {
                activityCallback.setToolbarTitle(title);
            }
            activityCallback.setToolbarUpIconBack();
        }
        this.presenter = new VisualUserStepsListPresenter(this);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (getActivity() instanceof BugReportingActivityCallback) {
            try {
                activityCallback = (BugReportingActivityCallback) getActivity();
            } catch (Exception e) {
                throw new RuntimeException("Must implement BugReportingActivityCallBack");
            }
        }
    }

    @Nullable
    protected String getTitle() {
        return title;
    }


    @Override
    protected int getLayout() {
        return R.layout.ibg_bug_fragment_repro_steps_list;
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        TextView description = findViewById(R.id.instabug_vus_list_header);
        if (description != null) {
            description.setText(getDescription());
        }
        if (getActivity() instanceof ReportingContainerActivity) {
            ((ReportingContainerActivity) getActivity()).setToolbarNavigationContentDescription(R.string.ibg_bug_visited_screen_back_btn_content_description);
        }
        emptyView = findViewById(R.id.instabug_vus_empty_label);
        stepsList = findViewById(R.id.instabug_vus_list);
        container = findViewById(R.id.instabug_vus_list_container);
        if (container != null) {
            container.setVisibility(View.INVISIBLE);
        }
        adapter = new VisualUserStepsListAdapter(this, theme);
        if (getContext() != null) {
            LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
            if (stepsList == null) {
                return;
            }

            stepsList.setLayoutManager(layoutManager);
            stepsList.setAdapter(adapter);
            DividerItemDecoration dividerItemDecoration = new DividerItemDecoration(stepsList.getContext(),
                    layoutManager.getOrientation());
            stepsList.addItemDecoration(dividerItemDecoration);

            if (presenter != null) {
                presenter.getVisualUserSteps();
            }
        }

        applyTheme(container, description);
    }

    @VisibleForTesting
    public void applyTheme(@Nullable LinearLayout container, @Nullable TextView descriptionTv) {
        if(theme != null) {
            int bgColor = theme.getBackgroundColor();
            if(bgColor != 0 && container != null) {
                container.setBackgroundColor(bgColor);
            }

            applyPrimaryTextStyle(descriptionTv, theme);
        }
    }


    private String getDescription() {
        return PlaceHolderUtils.getPlaceHolder(getContext(),
                REPRO_STEPS_LIST_DESCRIPTION,
                R.string.IBGReproStepsListHeader);
    }

    @Override
    public void onDestroy() {
        if (presenter != null) {
            presenter.release();
        }
        if (activityCallback != null) {
            activityCallback.setToolbarUpIconClose();
            activityCallback.setToolbarTitle(currentTitle);
        }
        super.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            if (getActivity() != null) {
                getActivity().onBackPressed();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void showPreparingDialog() {
        if (preparingProgressDialog != null) {
            if (!preparingProgressDialog.isShowing()) {
                preparingProgressDialog.show();
            }
        } else {
            if (getActivity() != null) {
                preparingProgressDialog = new IBGProgressDialog.Builder()
                        .setMessage(getPreparingMessage())
                        .build(getActivity());
                preparingProgressDialog.show();
            }
        }
    }

    private String getPreparingMessage() {
        return PlaceHolderUtils.getPlaceHolder(getContext(),
                REPRO_STEPS_PROGRESS_DIALOG_BODY,
                R.string.instabug_str_dialog_message_preparing);
    }

    @Override
    public void dismissPreparingDialog() {
        if (getActivity() != null && !getActivity().isFinishing()) {
            if (preparingProgressDialog != null && preparingProgressDialog.isShowing()) {
                preparingProgressDialog.dismiss();
            }
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (getActivity() != null && !getActivity().isFinishing()) {
            if (preparingProgressDialog != null && preparingProgressDialog.isShowing()) {
                preparingProgressDialog.dismiss();
            }
        }
        preparingProgressDialog = null;
        stepsList = null;
        container = null;
        emptyView = null;
        adapter = null;
    }

    @Override
    public void onStepItemDelete(int position, VisitedScreen visitedScreen) {
        VisualUserStepsListPresenter presenter = this.presenter;
        if (presenter != null && getContext() != null) {
            presenter.deleteVisualUserStep(getContext(), position, visitedScreen);
        }
        this.presenter = presenter;
    }

    @Override
    public void onStepItemClick(@NonNull VisualUserStepArgs args) {
        // At this point, the file is decrypted
        if (DiskUtils.isFileExist(args.getScreenShotUri().replace(FLAG_ENCRYPTED, "")) && activityCallback != null) {
            activityCallback.openStepPreviewFragment(args);
        }
    }

    @Override
    public void populateVisualUserSteps(ArrayList<VisitedScreen> visualUserSteps) {
        if (container == null || stepsList == null || emptyView == null || adapter == null) return;

        container.setVisibility(View.VISIBLE);
        if (visualUserSteps.isEmpty()) {
            stepsList.setVisibility(View.GONE);
            emptyView.setVisibility(View.VISIBLE);
            emptyView.setText(getEmptyStateDescription());
            handleInstabugTheme();
        } else {
            stepsList.setVisibility(View.VISIBLE);
            emptyView.setVisibility(View.GONE);
            adapter.setData(visualUserSteps);
        }
    }

    private String getEmptyStateDescription() {
        return PlaceHolderUtils.getPlaceHolder(getContext(),
                REPRO_STEPS_LIST_EMPTY_STATE_DESCRIPTION,
                R.string.IBGReproStepsListEmptyStateLabel);
    }

    private void handleInstabugTheme() {
        if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            emptyView.setBackgroundDrawable(getResources().getDrawable(
                    R.drawable.ibg_bug_vus_empty_view_background_light));
        } else {
            emptyView.setBackgroundDrawable(getResources().getDrawable(
                    R.drawable.ibg_bug_vus_empty_view_background_dark));
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams) emptyView.getLayoutParams();
            layoutParams.setMargins(0, 0, 0, 0);
        }
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        menu.clear();
    }
}
