package com.instabug.bug.onboardingbugreporting;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;

import com.instabug.bug.Constants;
import com.instabug.bug.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.view.ViewUtils;

public class OnboardingPagerFragment extends InstabugBaseFragment {
    private static final String EXTRA_KEY_IMG = "img";
    private static final String EXTRA_KEY_TITLE = "title";
    private static final String EXTRA_KEY_SUBTITLE = "subtitle";
    private static final String EXTRA_KEY_SET_LIVE_PADDING = "setLivePadding";
    private static final String TAG = "OnboardingPagerFragment";

    @Nullable
    private String title, subtitle;
    @DrawableRes
    private int imgRes;
    private boolean shouldSetLivePadding = false;

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public static OnboardingPagerFragment newInstance(@DrawableRes int imgRes,
                                                      @Nullable String title,
                                                      @Nullable String subtitle) {
        Bundle args = new Bundle();
        args.putInt(EXTRA_KEY_IMG, imgRes);
        args.putString(EXTRA_KEY_TITLE, title);
        args.putString(EXTRA_KEY_SUBTITLE, subtitle);
        OnboardingPagerFragment fragment = new OnboardingPagerFragment();
        fragment.setArguments(args);
        return fragment;
    }
    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            title = getArguments().getString(EXTRA_KEY_TITLE);
            subtitle = getArguments().getString(EXTRA_KEY_SUBTITLE);
            imgRes = getArguments().getInt(EXTRA_KEY_IMG);
            shouldSetLivePadding = getArguments().getBoolean(EXTRA_KEY_SET_LIVE_PADDING);
        }
    }
    @Override
    protected int getLayout() {
        return R.layout.ib_bug_reporting_lyt_onboarding_pager_fragment;
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        TextView titleTv = (TextView) findViewById(R.id.ib_bg_tv_title);
        TextView subtitleTv = (TextView) findViewById(R.id.ib_bg_tv_subtitle);
        ImageView imageIv = (ImageView) findViewById(R.id.ib_bg_img_onboarding);
        RelativeLayout container = (RelativeLayout) findViewById(R.id.ib_bg_lyt_onboarding_pager_fragment);

        Context context = getContext();
        if (container != null && context != null) {
            if (LocaleUtils.isRTL(InstabugCore.getLocale(context))) {
                container.setRotation(180);
            }
            if (shouldSetLivePadding) {
                container.setPadding(ViewUtils.convertDpToPx(context, 16),
                        ViewUtils.convertDpToPx(context, 24),
                        ViewUtils.convertDpToPx(context, 16),
                        ViewUtils.convertDpToPx(context, 16));
            }
        }

        if (titleTv != null) {
            titleTv.setText(title);
        }
        if (subtitleTv != null) {
            subtitleTv.setText(subtitle);
        }
        try {
            if (imageIv != null) {
                imageIv.setImageResource(imgRes);
                imageIv.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                int px = ViewUtils.convertDpToPx(context, 1);
                imageIv.setPadding(-px, -px, -px, -px);
            }
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG,"something went wrong" + e.getMessage());
        }
    }
    public static OnboardingPagerFragment newInstance(int drawableRes, @Nullable String title, @Nullable String content, boolean setLivePadding) {
       OnboardingPagerFragment onboardingPagerFragment = newInstance(drawableRes, title, content);
        if (onboardingPagerFragment.getArguments() != null) {
            onboardingPagerFragment.getArguments().putBoolean(EXTRA_KEY_SET_LIVE_PADDING, setLivePadding);
        }
        return onboardingPagerFragment;
    }
}

