package com.instabug.bug.network

import android.content.Context
import com.instabug.bug.di.ServiceLocator
import com.instabug.bug.model.Bug

class NormalBugsUploaderJob private constructor(): InstabugBugsUploaderJob() {

    companion object {
        private val instance = NormalBugsUploaderJob()

        @JvmStatic
        fun getInstance(): NormalBugsUploaderJob = instance
    }
    override fun getBugs(context: Context?): MutableList<Bug> {
        return ServiceLocator.getBugReportsDbHelper().retrieveNormalBugs(context)
    }

    override fun onBugUploaded() {
        //Not needed here
    }
}