package com.instabug.bug;

import com.instabug.bug.Constants.ReportType;

import androidx.annotation.NonNull;


/**
 * Created by tarek on 8/28/17.
 */

public interface OnSdkDismissedCallback {

    /**
     * Called when Instabug SDK is dismissed providing relevant information
     *
     * @param issueState whether bug/feedback was submitted, cancelled or in_progress
     * @param reportType the submitted report type
     */
    void onSdkDismissed(@NonNull DismissType issueState, @NonNull ReportType reportType);

    enum DismissType {
        /**
         * Indicates that the issue was submitted and to be uploaded
         */
        SUBMIT,
        /**
         * Indicates that the user cancelled the SDK without submission
         */
        CANCEL,
        /**
         * Indicates that the issue reporting scenario is in progress (taking another screenshot
         * from app, etc...)
         */
        ADD_ATTACHMENT
    }
}
