package com.instabug.chat.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;

import com.instabug.chat.model.Attachment;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;
import androidx.annotation.Nullable;

public class ChatActivityLauncher {

    public static final int PROCESS_CHATS = 0xa0;
    public static final int PROCESS_CHAT = 0xa1;
    public static final int PROCESS_NEW_CHAT = 0xa2;
    public static final int PROCESS_HANGING_CHAT = 0xa4;
    public static final String EXTRA_PROCESS = "chat_process";
    public static final String EXTRA_CHAT_NUMBER = "chat_number";
    public static final String EXTRA_ATTACHMENT = "attachment";
    public static final String EXTRA_COMPOSE = "compose";

    public static Intent chatsProcessIntent(Context context) {
        Intent intent = new Intent(context, ChatActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_CHATS);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        return intent;
    }


    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public static Intent chatProcessIntent(Context context, @Nullable String chatNumber) {
        Intent intent = new Intent(context, ChatActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_CHAT);
        intent.putExtra(EXTRA_CHAT_NUMBER, chatNumber);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        return intent;
    }

    public static Intent newChatProcessIntent(Context context) {
        Intent intent = new Intent(context, ChatActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_NEW_CHAT);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        return intent;
    }

    public static Intent hangingChatProcessIntent(Context context, String chatNumber, Attachment
            attachment) {
        Intent intent = new Intent(context, ChatActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_HANGING_CHAT);
        intent.putExtra(EXTRA_CHAT_NUMBER, chatNumber);
        intent.putExtra(EXTRA_ATTACHMENT, attachment);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        return intent;
    }

    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            PROCESS_CHATS,
            PROCESS_CHAT,
            PROCESS_NEW_CHAT,
            PROCESS_HANGING_CHAT})
    public @interface ChatProcess {
    }
}
