package com.instabug.chat.settings;

import android.os.Build;

import java.io.Serializable;

public class AttachmentTypesState implements Serializable {

    private boolean screenshotEnabled;
    private boolean imageFromGalleryEnabled;
    private boolean screenRecordingEnabled;

    public AttachmentTypesState() {
        screenshotEnabled = true;
        imageFromGalleryEnabled = true;
        screenRecordingEnabled = true;
    }

    public AttachmentTypesState(boolean screenshotEnabled, boolean ImageFromGalleryEnabled, boolean screenRecordingEnabled) {
        this.screenshotEnabled = screenshotEnabled;
        this.imageFromGalleryEnabled = ImageFromGalleryEnabled;
        this.screenRecordingEnabled = screenRecordingEnabled;
    }

    public boolean isScreenshotEnabled() {
        return screenshotEnabled;
    }

    public AttachmentTypesState setScreenshotEnabled(boolean screenshotEnabled) {
        this.screenshotEnabled = screenshotEnabled;
        return this;
    }

    public boolean isImageFromGalleryEnabled() {
        return imageFromGalleryEnabled;
    }

    public AttachmentTypesState setImageFromGalleryEnabled(boolean imageFromGalleryEnabled) {
        this.imageFromGalleryEnabled = imageFromGalleryEnabled;
        return this;
    }

    public boolean isScreenRecordingEnabled() {
        return screenRecordingEnabled && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;
    }

    public AttachmentTypesState setScreenRecordingEnabled(boolean screenRecordingEnabled) {
        this.screenRecordingEnabled = screenRecordingEnabled;
        return this;
    }

    @Override
    public String toString() {
        return screenshotEnabled + ", " + imageFromGalleryEnabled
                + ", " + screenRecordingEnabled;
    }
}
