/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.f;
import com.instabug.bug.settings.b;
import com.instabug.bug.utils.c;
import com.instabug.bug.view.actionList.service.a;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;

public class BugPlugin
extends Plugin {
    @Nullable
    private IBGCompositeDisposable disposables;
    @Nullable
    @VisibleForTesting
    IBGDisposable mappedTokenChangedDisposable;

    private void subscribeOnCoreEvents() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            this.getOrCreateCompositeDisposables().add(this.subscribeToCoreEvents());
        }
    }

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                com.instabug.bug.b.a((Context)weakReference.get(), iBGSdkCoreEvent);
            }
        });
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangedDisposable == null) {
            this.mappedTokenChangedDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(bl -> {
                a.b().d();
                a.b().start();
            });
        }
    }

    private void unsubscribeFromMappedTokenChangedEvents() {
        IBGDisposable iBGDisposable = this.mappedTokenChangedDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangedDisposable = null;
        }
    }

    private void loadAndApplyCachedReproConfigurations() {
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            settingsManager = settingsManager.getReproConfigurations();
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (settingsManager != null && weakReference != null) {
                com.instabug.bug.b.a((Context)weakReference.get(), (IBGSdkCoreEvent)new IBGSdkCoreEvent.ReproState(settingsManager.getModesMap()));
            }
        }
    }

    private void unSubscribeFromCoreEvents() {
        BugPlugin bugPlugin = bugPlugin.disposables;
        if (bugPlugin != null) {
            bugPlugin.dispose();
        }
    }

    private IBGCompositeDisposable getOrCreateCompositeDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        Context context2 = context;
        com.instabug.bug.di.a.e().d();
        com.instabug.bug.di.a.i().evaluate((ReproConfigurationsProvider)com.instabug.bug.di.a.e());
        com.instabug.bug.di.a.j().addWatcher(4);
        com.instabug.bug.di.a.f().addWatcher(4);
        c.c(context2);
        super.init(context2);
    }

    public void wake() {
        com.instabug.bug.di.a.j().consentOnCleansing(4);
        com.instabug.bug.di.a.f().consentOnCleansing(4);
    }

    public void sleep() {
    }

    public void initDefaultPromptOptionAvailabilityState() {
        f.c();
    }

    public ArrayList<PluginPromptOption> getPromptOptions() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return f.a((Context)this.contextWeakReference.get());
        }
        return new ArrayList<PluginPromptOption>();
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean bl) {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return f.a(bl, (Context)this.contextWeakReference.get());
        }
        return null;
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"BUG_REPORTING");
    }

    public void stop() {
        BugPlugin bugPlugin = this;
        f.g();
        bugPlugin.unSubscribeFromCoreEvents();
        bugPlugin.unsubscribeFromMappedTokenChangedEvents();
    }

    public void start(Context context) {
        PoolProvider.postIOTaskWithCheck(() -> {
            if (Instabug.isEnabled() && b.h().q() && b.h().o() != 2) {
                new com.instabug.bug.onboardingbugreporting.utils.b().a();
            }
            BugPlugin bugPlugin = this;
            this.loadAndApplyCachedReproConfigurations();
            f.b(context);
            bugPlugin.subscribeOnCoreEvents();
            bugPlugin.subscribeOnMappedTokenChangedEvent();
            com.instabug.bug.network.b.b().start();
        });
    }

    public long getLastActivityTime() {
        return b.h().i();
    }

    public void onLocaleChanged(Locale locale, Locale locale2) {
        super.onLocaleChanged(locale, locale2);
        a.b().start();
    }
}

