package com.instabug.apm.webview.webview_trace.configuration

import com.instabug.apm.configuration.ConfigurationHandler
import com.instabug.apm.logger.APMLogger
import com.instabug.library.util.extenstions.runOrLogError
import org.json.JSONObject

class WebViewTraceConfigurationHandler(
    private val configurationProvider: WebViewTraceConfigurationProvider
) : ConfigurationHandler {

    override fun handleConfigurations(configsJson: JSONObject?) {
        configsJson?.optJSONObject("ui")
            ?.optJSONObject(WEB_VIEW_TRACES_ROOT_FLAG)
            ?.runOrLogError { parseWebViewConfigs() }
            ?: resetAndLogNotParsed()
    }

    private fun JSONObject.parseWebViewConfigs() =
        optBoolean(WEB_VIEW_FEATURE_ENABLED, DEFAULT_WEB_VIEW_FEATURE_ENABLED).let { enabled->
            configurationProvider.featureEnabled = enabled
            if (enabled) cacheWebViewConfigs() else reset()
        }

    private fun JSONObject.cacheWebViewConfigs() = configurationProvider.run {
        requestLimit = optInt(WEB_VIEW_REQUEST_LIMIT, DEFAULT_WEB_VIEW_REQUEST_LIMIT)
        storeLimit = optInt(WEB_VIEW_STORE_LIMIT, DEFAULT_WEB_VIEW_STORE_LIMIT)
        maxCallbackThresholdMs =
            optInt(WEB_VIEW_MAX_CALLBACK_THRESHOLD_MS, DEFAULT_WEB_VIEW_MAX_CALLBACK_THRESHOLD_MS)
        partialViewEnabled =
            optBoolean(WEB_VIEW_PARTIAL_FEATURE_ENABLED, DEFAULT_WEB_VIEW_PARTIAL_FEATURE_ENABLED)
        partialViewPercentage = optDouble(
            WEB_VIEW_PARTIAL_VIEW_PERCENTAGE,
            DEFAULT_WEB_VIEW_PARTIAL_PERCENTAGE.toDouble()
        ).toFloat()
    }

    private fun resetAndLogNotParsed() {
        APMLogger.logSDKProtected("Can't parse WebViews configurations, object is null.")
        reset()
    }

    override fun reset() = configurationProvider.reset()

}