package com.instabug.apm.webview.dispatch

import android.graphics.Bitmap
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import android.webkit.WebView
import com.instabug.apm.model.EventTimeMetricCapture

interface WebViewEventListener {

    fun onLoadUrl(id: Long, webView: WebView, url: String?, timeCapture: EventTimeMetricCapture)
    fun onLoadUrl(
        id: Long,
        webView: WebView,
        url: String?,
        headers: Map<String, String>?,
        timeCapture: EventTimeMetricCapture
    )
    fun onPostUrl(
        id: Long,
        webView: WebView,
        url: String?,
        postData: ByteArray?,
        timeCapture: EventTimeMetricCapture
    )

    fun onLoadData(
        id: Long,
        webView: WebView,
        timeCapture: EventTimeMetricCapture
    )
    fun onLoadDataWithBaseUrl(
        id: Long,
        webView: WebView,
        timeCapture: EventTimeMetricCapture
    )

    fun shouldOverrideUrlLoadingStarted(
        id: Long,
        view: WebView?,
        request: WebResourceRequest?,
        timeCapture: EventTimeMetricCapture
    )

    fun shouldOverrideUrlLoadingEnded(
        id: Long,
        view: WebView?,
        request: WebResourceRequest?,
        override: Boolean,
        timeCapture: EventTimeMetricCapture
    )

    fun onPageStarted(
        id: Long,
        view: WebView?,
        url: String?,
        favicon: Bitmap?,
        timeCapture: EventTimeMetricCapture
    )

    fun onPageFinished(
        id: Long,
        view: WebView?,
        url: String?,
        timeCapture: EventTimeMetricCapture
    )

    fun onReceivedError(
        id: Long,
        view: WebView?,
        request: WebResourceRequest?,
        error: WebResourceError?,
        timeCapture: EventTimeMetricCapture
    )

    fun onReceivedHttpError(
        id: Long,
        view: WebView?,
        request: WebResourceRequest?,
        errorResponse: WebResourceResponse?,
        timeCapture: EventTimeMetricCapture
    )
}