package com.instabug.apm.util.debug;

import android.annotation.SuppressLint;
import android.content.Context;

import androidx.annotation.Nullable;

import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DebugUtilsImpl implements DebugUtils {

    @Nullable
    private Context context = ServiceLocator.getContext();
    private Logger logger = ServiceLocator.getApmLogger();
    private static final String DEBUG_PROPERTY = "debug.instabug.apm.app";

    @Override
    public boolean isInDebugMode() {
        String packageName = "";
        if (context != null) {
            packageName = context.getApplicationContext().getPackageName();
        }
        String prop = getProp(DEBUG_PROPERTY);
        return !packageName.isEmpty() && packageName.equals(prop);
    }

    @Nullable
    @SuppressLint("PrivateApi")
    public String getProp(String key) {
        try {
            Class c = Class.forName("android.os.SystemProperties");
            try {
                Method method = c.getDeclaredMethod("get", String.class);
                try {
                    return (String) method.invoke(null, key);
                } catch (IllegalAccessException e) {
                    logger.logSDKError(e.getMessage() != null ? e.getMessage() : "", e);
                } catch (InvocationTargetException e) {
                    logger.logSDKError(e.getMessage() != null ? e.getMessage() : "", e);
                }
            } catch (NoSuchMethodException e) {
                logger.logSDKError(e.getMessage() != null ? e.getMessage() : "", e);
            }
        } catch (ClassNotFoundException e) {
            logger.logSDKError(e.getMessage() != null ? e.getMessage() : "", e);
        }
        return null;
    }
}
