package com.instabug.apm.networkinterception.repository

import com.instabug.apm.sanitization.AsyncSanitizer
import com.instabug.library.logging.listeners.networklogs.NetworkLogListener
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot

interface NetworkInterceptionRepository {
    var networkLogListener: NetworkLogListener?
    var asyncSanitizer: AsyncSanitizer<NetworkLogSnapshot>?
}

class NetworkInterceptionRepositoryImpl : NetworkInterceptionRepository {

    @Volatile
    override var networkLogListener: NetworkLogListener? = null
        get() = if (asyncSanitizer != null) null else field

    @Volatile
    override var asyncSanitizer: AsyncSanitizer<NetworkLogSnapshot>? = null
}