package com.instabug.apm.networkinterception

import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.model.NetworkTrace
import com.instabug.apm.model.NetworkTraceBuilder
import com.instabug.library.map.Mapper

class NetworkLogToTraceMapper : Mapper<APMNetworkLog, NetworkTrace> {

    /**
     * Converts {@link APMNetworkLog} instance to the public {@link NetworkTrace}
     *
     * @return a public replica instance of the this {@link APMNetworkLog}
     */
    override fun map(from: APMNetworkLog): NetworkTrace = with(from) {
        NetworkTraceBuilder()
            .carrier(carrier)
            .errorMessage(errorMessage)
            .method(method)
            .radio(radio)
            .requestBody(requestBody)
            .requestBodySize(requestBodySize)
            .requestContentType(requestContentType)
            .requestHeaders(requestHeaders)
            .responseBody(responseBody)
            .responseBodySize(responseBodySize)
            .responseContentType(responseContentType)
            .responseHeaders(responseHeaders)
            .responseCode(responseCode)
            .startTime(startTime)
            .url(url)
            .totalDuration(totalDuration)
            .build()
    }
}