package com.instabug.apm.networking.mapping.uiloading;

import static com.instabug.apm.networking.mapping.uiloading.UiLoadingMappingKeys.DURATION_MUS;
import static com.instabug.apm.networking.mapping.uiloading.UiLoadingMappingKeys.STAGES;
import static com.instabug.apm.networking.mapping.uiloading.UiLoadingMappingKeys.START_TIMESTAMP;
import static com.instabug.apm.networking.mapping.uiloading.UiLoadingMappingKeys.TYPE;

import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.UiLoadingModel;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;
import java.util.Set;

public class UiLoadingMapperImpl implements UiLoadingMapper {

    @Nullable
    @Override
    public JSONObject toJson(@Nullable UiLoadingModel model) throws JSONException {
        if (model == null) {
            return null;
        }
        String type = model.getType();
        Map<String, Long> stages = model.getStages();
        JSONObject uiLoadingJsonObject = new JSONObject();
        uiLoadingJsonObject.put(DURATION_MUS, model.getDurationInMicro());
        uiLoadingJsonObject.put(START_TIMESTAMP, model.getStartTimeStampMicro());
        if (type != null) {
            uiLoadingJsonObject.put(TYPE, type);
        }
        if (stages != null) {
            JSONObject stagesJsonObject = new JSONObject();
            Set<Map.Entry<String, Long>> entries = stages.entrySet();
            for (Map.Entry<String, Long> entry: entries) {
                JSONArray stageDurationsJsonArray = new JSONArray();
                stageDurationsJsonArray.put(entry.getValue());
                stagesJsonObject.put(entry.getKey(), stageDurationsJsonArray);
            }
            uiLoadingJsonObject.put(STAGES, stagesJsonObject);
        }
        return uiLoadingJsonObject;
    }
}
