package com.instabug.apm.logger;

import androidx.annotation.NonNull;

import com.instabug.apm.di.ServiceLocator;

/**
 * Wrapper class for {@link com.instabug.apm.logger.internal.Logger} to be kept from proguard
 */
public final class APMLogger {

    private APMLogger() {
    }

    public static void logSDKVerbose(@NonNull String message) {
        ServiceLocator.getApmLogger().logSDKVerbose(message);
    }

    public static void logSDKInfo(@NonNull String message) {
        ServiceLocator.getApmLogger().logSDKInfo(message);
    }

    public static void logSDKDebug(@NonNull String message) {
        ServiceLocator.getApmLogger().logSDKDebug(message);
    }

    public static void logSDKWarning(@NonNull String message) {
        ServiceLocator.getApmLogger().logSDKWarning(message);
    }

    public static void logSDKError(@NonNull String message, @NonNull Throwable throwable) {
        ServiceLocator.getApmLogger().logSDKError(message, throwable);
    }

    public static void logSDKError(@NonNull String message) {
        ServiceLocator.getApmLogger().logSDKError(message);
    }

    public static void logSDKProtected(@NonNull String message) {
        ServiceLocator.getApmLogger().logSDKProtected(message);
    }

    public static void v(String message) {
        ServiceLocator.getApmLogger().v(message);
    }

    public static void i(String message) {
        ServiceLocator.getApmLogger().i(message);
    }

    public static void d(String message) {
        ServiceLocator.getApmLogger().d(message);
    }

    public static void w(String message) {
        ServiceLocator.getApmLogger().w(message);
    }

    public static void e(String message) {
        ServiceLocator.getApmLogger().e(message);
    }
}
