package com.instabug.apm.handler.networklog

import com.instabug.apm.constants.ErrorMessages.SANITIZATION_FAILED_WITH_EXCEPTION
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.sanitization.Sanitizer

class NetworkLogHandlerSanitizationDecorator(
    private val handler: NetworkLogHandler,
    private val sanitizer: Sanitizer<APMNetworkLog>,
    private val logger: Logger
) : NetworkLogHandler by handler {
    override fun insertNetworkLog(networkLog: APMNetworkLog): Long =
        runCatching {
            sanitizer.sanitize(networkLog)
        }.getOrElse { error ->
            logger.logSDKErrorWithStackTrace(SANITIZATION_FAILED_WITH_EXCEPTION, error)
            null
        }?.let(handler::insertNetworkLog) ?: -1L
}