package com.instabug.apm.di

import android.content.Context
import com.instabug.apm.handler.fragment.FragmentSpansHandler
import com.instabug.library.internal.storage.cache.db.DatabaseManager
import com.instabug.apm.util.isCurrentPlatformCP

class ContextProvider : Provider<Context?> {
    override fun invoke(): Context? = ServiceLocator.getContext()
}

class FragmentSpansHandlerProvider : Provider<FragmentSpansHandler?> {
    override fun invoke(): FragmentSpansHandler? =
        ServiceLocator.getFragmentSpansHandler()
}

class DatabaseProvider : Provider<DatabaseManager?> {
    override fun invoke(): DatabaseManager? = ServiceLocator.getDatabaseManager()
}

class IsCurrentPlatformCpProvider : Provider<Boolean> {
    override fun invoke(): Boolean = isCurrentPlatformCP
}