package com.instabug.apm.configuration

import android.content.SharedPreferences
import kotlin.reflect.KProperty

open class ReadOnceAPMPreferenceProperty<T>(
    sharedPreferences: SharedPreferences,
    key: String,
    defaultValue: T
) : APMPreferenceProperty<T>(sharedPreferences, key, defaultValue) {

    override fun setValue(thisRef: Any?, property: KProperty<*>, value: T) {
        persistValue(value)
    }

    override fun clear() {
        clearPersistedValue()
    }
}