package com.instabug.apm.compose.external_compose

import com.instabug.apm.compose.compose_spans.ComposeSpansServiceLocator
import com.instabug.apm.di.ServiceLocator

object ExternalComposeServiceLocator {

    @Volatile
    private var _configurationProvider: ExternalComposeConfigurationProvider? = null
    val configurationProvider: ExternalComposeConfigurationProvider?
        get() = _configurationProvider ?: synchronized(ServiceLocator.getServiceLocatorLock()) {
            _configurationProvider ?: createConfigurationsProvider()
        }

    private fun createConfigurationsProvider() =
        ComposeSpansServiceLocator.configurationProvider?.let {
            ExternalComposeConfigurationProviderImpl(it).also { cfg -> _configurationProvider = cfg }
        }
}