package com.instabug.apm.compose.compose_spans.model.transform

import com.instabug.apm.constants.ErrorMessages.COMPOSABLE_NAME_EMPTY
import com.instabug.apm.constants.ErrorMessages.COMPOSABLE_NAME_INVALID_LENGTH
import com.instabug.apm.logger.internal.Logger
import com.instabug.library.map.Mapper

class ComposableNameLengthSanitizer(
    private val maxAllowedLength: Int,
    private val logger: Logger
    ): Mapper<String, String?> {

    override fun map(from: String): String? = from.trim().let { trimmedName ->
        if (trimmedName.isEmpty()) {
            logger.logSDKError(COMPOSABLE_NAME_EMPTY)
            null
        } else if (trimmedName.length > maxAllowedLength) {
            logger.logSDKWarning(
                COMPOSABLE_NAME_INVALID_LENGTH
                    .replace("\$s", from)
                    .replace("\$L", "$maxAllowedLength")
            )
            trimmedName.substring(0, maxAllowedLength)
        } else {
            trimmedName
        }
    }
}